% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_content.r, R/deprecated.r
\name{check_las_validity}
\alias{check_las_validity}
\alias{check_las_compliance}
\alias{check_data_vs_header}
\title{Check if data and headers respect the LAS specification}
\usage{
check_las_validity(header, data)

check_las_compliance(header, data)

check_data_vs_header(header, data, ...)
}
\arguments{
\item{header}{a list containing the header of a las file}

\item{data}{a data.frame or a data.table containing a point cloud}

\item{...}{internal use only}
}
\description{
las files are normalized files. These functions perform tests of compliance with LAS specification.
\itemize{
\item \code{check_las_validity} tests if the data and the header contain information that cannot be
written into a las file. For example it tests is the intensities do not exeed 65535. It throws an
error for each deviance to the specification. It is useful for testing if modified R objects are
still valid.
\item \code{check_las_compliance} test if the data and the header contain information
that can be written into a las file but are invalid with repect of the specification. For example it
test if the RGB colors are recoded on 16 bits. It is possible to store colors recorded on 8 bits
(0 to 255) but it is not correct to do that. It throws a warning for each deviance to the specification.
It is useful for testing if the data read from a file are correct.
}
}
