% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rliger.R
\docType{class}
\name{liger-class}
\alias{liger-class}
\alias{liger}
\title{The LIGER Class}
\description{
The liger object is created from two or more single cell datasets. To construct a
liger object, the user needs to provide at least two expression (or another
single-cell modality) matrices. The class provides functions for data
preprocessing, integrative analysis, and visualization.
}
\details{
The key slots used in the liger object are described below.
}
\section{Slots}{

\describe{
\item{\code{raw.data}}{List of raw data matrices, one per experiment/dataset (genes by cells)}

\item{\code{norm.data}}{List of normalized matrices (genes by cells)}

\item{\code{scale.data}}{List of scaled matrices (cells by genes)}

\item{\code{sample.data}}{List of sampled matrices (gene by cells)}

\item{\code{h5file.info}}{List of HDF5-related information for each input dataset. Paths to raw data, indices,
indptr, barcodes, genes and  the pipeline through which the HDF5 file is formated (10X, AnnData, etc),
type of sampled data (raw, normalized or scaled).}

\item{\code{cell.data}}{Dataframe of cell attributes across all datasets (nrows equal to total number
cells across all datasets)}

\item{\code{var.genes}}{Subset of informative genes shared across datasets to be used in matrix
factorization}

\item{\code{H}}{Cell loading factors (one matrix per dataset, dimensions cells by k)}

\item{\code{H.norm}}{Normalized cell loading factors (cells across all datasets combined into single
matrix)}

\item{\code{W}}{Shared gene loading factors (k by genes)}

\item{\code{V}}{Dataset-specific gene loading factors (one matrix per dataset, dimensions k by genes)}

\item{\code{A}}{Matrices used for online learning (XH)}

\item{\code{B}}{Matrices used for online learning (HTH)}

\item{\code{tsne.coords}}{Matrix of 2D coordinates obtained from running t-SNE on H.norm or H matrices}

\item{\code{alignment.clusters}}{Initial joint cluster assignments from shared factor alignment}

\item{\code{clusters}}{Joint cluster assignments for cells}

\item{\code{snf}}{List of values associated with shared nearest factor matrix for use in clustering and
alignment (out.summary contains edge weight information between cell combinations)}

\item{\code{agg.data}}{Data aggregated within clusters}

\item{\code{parameters}}{List of parameters used throughout analysis}

\item{\code{version}}{Version of package used to create object}
}}

