% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rliger.R
\name{plotByDatasetAndCluster}
\alias{plotByDatasetAndCluster}
\title{Plot t-SNE coordinates of cells across datasets}
\usage{
plotByDatasetAndCluster(
  object,
  clusters = NULL,
  title = NULL,
  pt.size = 0.3,
  text.size = 3,
  do.shuffle = TRUE,
  rand.seed = 1,
  axis.labels = NULL,
  do.legend = TRUE,
  legend.size = 5,
  reorder.idents = FALSE,
  new.order = NULL,
  return.plots = FALSE,
  legend.fonts.size = 12
)
}
\arguments{
\item{object}{\code{liger} object. Should call runTSNE or runUMAP before calling.}

\item{clusters}{Another clustering to use for coloring second plot (must have same names as
clusters slot) (default NULL).}

\item{title}{Plot titles (list or vector of length 2) (default NULL).}

\item{pt.size}{Controls size of points representing cells (default 0.3).}

\item{text.size}{Controls size of plot text (cluster center labels) (default 3).}

\item{do.shuffle}{Randomly shuffle points so that points from same dataset are not plotted
one after the other (default TRUE).}

\item{rand.seed}{Random seed for reproducibility of point shuffling (default 1).}

\item{axis.labels}{Vector of two strings to use as x and y labels respectively.}

\item{do.legend}{Display legend on plots (default TRUE).}

\item{legend.size}{Size of legend on plots (default 5).}

\item{reorder.idents}{logical whether to reorder the datasets from default order before plotting (default FALSE).}

\item{new.order}{new dataset factor order for plotting.  must set reorder.idents = TRUE.}

\item{return.plots}{Return ggplot plot objects instead of printing directly (default FALSE).}

\item{legend.fonts.size}{Controls the font size of the legend.}
}
\value{
List of ggplot plot objects (only if return.plots TRUE, otherwise prints plots to
  console).
}
\description{
Generates two plots of all cells across datasets, one colored by dataset and one colored by
cluster. These are useful for visually examining the alignment and cluster distributions,
respectively. If clusters have not been set yet (quantileAlignSNF not called), will plot by
single color for second plot. It is also possible to pass in another clustering (as long as
names match those of cells).
}
\examples{
\dontrun{
# ligerex (liger object), factorization complete
# get tsne.coords for normalized data
ligerex <- runTSNE(ligerex)
# plot to console
plotByDatasetAndCluster(ligerex)
# return list of plots
plots <- plotByDatasetAndCluster(ligerex, return.plots = TRUE)
}
}
