/*
 * Decompiled with CFR 0.152.
 */
package dmLab.mcfs.mcfsEngine.framework;

import dmLab.array.FArray;
import dmLab.array.functions.DiscFunctions;
import dmLab.array.loader.File2Array;
import dmLab.classifier.Params;
import dmLab.mcfs.MCFSParams;
import dmLab.mcfs.attributesRI.Ranking;
import dmLab.mcfs.cutoffMethods.Cutoff;
import dmLab.mcfs.mcfsEngine.arrays.MCFSArrays;
import dmLab.mcfs.mcfsEngine.framework.GlobalStats;
import dmLab.mcfs.mcfsEngine.framework.MCFSJob;
import dmLab.utils.cmatrix.ConfusionMatrix;
import dmLab.utils.dataframe.DataFrame;
import java.io.File;
import java.util.Date;
import java.util.Random;

public abstract class MCFSFramework
implements Runnable {
    public MCFSParams mcfsParams;
    public MCFSArrays mcfsArrays;
    public GlobalStats globalStats;
    public String experimentName;
    public boolean saveResutFiles = true;
    protected Random random;

    /*
     * WARNING - void declaration
     */
    public MCFSFramework(Random random) {
        void var1_1;
        this.random = var1_1;
        this.experimentName = "";
        this.mcfsArrays = new MCFSArrays();
    }

    /*
     * WARNING - void declaration
     */
    private void cleanTmpWekaFiles() {
        int i = 0;
        while (i < this.mcfsParams.threadsNumber) {
            void var3_3;
            void var2_2;
            String trainFilePath = String.valueOf(this.mcfsParams.resFilesPATH) + "C" + i + "_tmp_train.arff";
            String testFilePath = String.valueOf(this.mcfsParams.resFilesPATH) + "C" + i + "_tmp_test.arff";
            File trainFile = new File(trainFilePath);
            File testFile = new File(testFilePath);
            var2_2.delete();
            var3_3.delete();
            ++i;
        }
    }

    @Override
    public abstract void run();

    public final boolean run(MCFSParams mcfsParams) {
        boolean bl;
        Object object;
        this.mcfsParams = ((MCFSParams)object).clone();
        object = this;
        MCFSParams mCFSParams = ((MCFSFramework)object).mcfsParams;
        object = ((MCFSFramework)object).mcfsArrays;
        ((MCFSFramework)object).mcfsArrays.sourceArray = new FArray();
        System.out.print("Loading Input Table...");
        File2Array file2Array = new File2Array();
        if (!file2Array.load(((MCFSArrays)object).sourceArray, String.valueOf(mCFSParams.inputFilesPATH) + mCFSParams.inputFileName)) {
            bl = false;
        } else if (!((MCFSArrays)object).sourceArray.checkDecisionValues()) {
            bl = false;
        } else {
            if (mCFSParams.debug) {
                System.out.println("### DEBUG ### InputArray\n" + ((MCFSArrays)object).sourceArray.toString());
            }
            ((MCFSArrays)object).sourceArray.findDomains();
            bl = true;
        }
        if (!bl) {
            return false;
        }
        this.run();
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final ConfusionMatrix runExperiment(FArray inputArray) {
        void var1_1;
        void var3_7;
        if (this.mcfsParams.verbose) {
            System.out.println(this.mcfsParams.toString());
        }
        if (!this.mcfsParams.check(inputArray)) {
            return null;
        }
        System.out.println("MCFS-ID: " + Params.booleanParamToString(this.mcfsParams.buildID, "ID-Graph"));
        System.out.println("MCFS-ID: " + Params.booleanParamToString(this.mcfsParams.finalCV, "finalCV"));
        System.out.println("MCFS-ID: " + Params.booleanParamToString(this.mcfsParams.finalRuleset, "finalRuleset"));
        System.out.println("MCFS-ID: " + Params.booleanParamToString(this.mcfsParams.splitSetSize > 0, "Input data size limitation"));
        System.out.println("MCFS-ID: " + Params.booleanParamToString(this.mcfsParams.balanceRatio > 0.0f, "Classes balancing"));
        if (this.mcfsParams.balanceRatio > 0.0f) {
            DiscFunctions.getBalancedClassSizes(this.mcfsArrays.sourceArray, this.mcfsParams.balanceRatio, true);
        }
        this.globalStats = new GlobalStats();
        this.globalStats.init(inputArray, this.mcfsParams, this.experimentName);
        Cutoff cutoff = new Cutoff(this.mcfsParams);
        this.globalStats.setCutoff(cutoff);
        if (this.mcfsParams.contrastAttr) {
            System.out.println("Adding Contrast Attributes...");
            DiscFunctions.addContrastAttributes(inputArray);
            FArray fArray = inputArray;
            System.out.println("New input array size: attributes: " + fArray.attributes.length + " events: " + inputArray.rowsNumber());
        }
        int threadsNumber = this.mcfsParams.threadsNumber;
        System.out.println("Starting MCFS-ID Single Experiment. Projections(s) = " + this.mcfsParams.projections + " Splits(t) = " + this.mcfsParams.splits);
        long start = System.currentTimeMillis();
        System.out.println("Start: " + new Date(start).toString());
        MCFSJob[] mcfsJob = new MCFSJob[threadsNumber];
        Thread[] jobs = new Thread[threadsNumber];
        int i = 0;
        while (i < threadsNumber) {
            mcfsJob[i] = new MCFSJob(i, this.mcfsParams, inputArray, this.globalStats);
            mcfsJob[i].init(new Random(this.random.nextLong()));
            jobs[i] = new Thread(mcfsJob[i]);
            jobs[i].setPriority(8);
            ++i;
        }
        System.out.println("Starting: " + threadsNumber + " threads.");
        i = 0;
        while (i < jobs.length) {
            jobs[i].start();
            System.out.println("Thread " + i + " Started...");
            ++i;
        }
        try {
            i = 0;
            while (i < jobs.length) {
                jobs[i].join();
                ++i;
            }
        }
        catch (InterruptedException interruptedException) {
            InterruptedException i2 = interruptedException;
            interruptedException.printStackTrace();
        }
        System.out.println("All " + threadsNumber + " threads are finished.");
        int i3 = 0;
        while (i3 < threadsNumber) {
            mcfsJob[i3].finish();
            ++i3;
        }
        long stop = System.currentTimeMillis();
        ConfusionMatrix confusionMatrix = this.globalStats.getConfusionMatrix();
        float experimentTime = (float)(stop - start) / 1000.0f;
        System.out.println("stop: " + new Date(stop).toString());
        System.out.println(confusionMatrix.toString());
        System.out.println(confusionMatrix.statsToString(4));
        if (this.globalStats.getAttrConnections() != null) {
            this.globalStats.getAttrConnections().findMinMaxID();
            if (this.saveResutFiles) {
                this.globalStats.getAttrConnections().save(String.valueOf(this.mcfsParams.resFilesPATH) + this.experimentName + "_" + MCFSParams.FILESUFIX_CONNECTIONS);
            }
        }
        DataFrame distances = this.globalStats.getDistances();
        if (this.saveResutFiles) {
            DiscFunctions.saveString(String.valueOf(this.mcfsParams.resFilesPATH) + this.experimentName + "_" + MCFSParams.FILESUFIX_DISTANCE, distances.toString());
        }
        String matrix = confusionMatrix.toString(false, true, false, ",");
        if (this.saveResutFiles) {
            DiscFunctions.saveString(String.valueOf(this.mcfsParams.resFilesPATH) + this.experimentName + "_" + MCFSParams.FILESUFIX_MATRIX, matrix);
        }
        double minRI = cutoff.calcCutoff(this.globalStats.getAttrImportances()[0]);
        System.out.println("Minimal important (based on all cutoff methods) RI = " + DiscFunctions.format(minRI, 7));
        if (this.saveResutFiles) {
            DiscFunctions.saveString(String.valueOf(this.mcfsParams.resFilesPATH) + this.experimentName + "_" + MCFSParams.FILESUFIX_CUTOFF, cutoff.toString());
        }
        int mainMeasureIndex = this.globalStats.getAttrImportances()[0].mainMeasureIdx;
        Ranking topRanking = this.globalStats.getAttrImportances()[0].getTopRanking(mainMeasureIndex, (float)minRI);
        if (topRanking != null) {
            System.out.println("Size of important (based on all cutoff methods) attributes set = " + topRanking.size());
            if (this.saveResutFiles) {
                void var2_4;
                DiscFunctions.saveString(String.valueOf(this.mcfsParams.resFilesPATH) + this.experimentName + "_" + MCFSParams.FILESUFIX_TOPRANKING, var2_4.toString());
            }
        }
        System.out.println("*** MCFS-ID single experiment has been done! ***");
        System.out.println("*** MCFS-ID single experiment time (s.): " + (float)var3_7 + " ***");
        this.cleanTmpWekaFiles();
        if (this.saveResutFiles) {
            DiscFunctions.saveString(String.valueOf(this.mcfsParams.resFilesPATH) + this.experimentName + ".run", this.mcfsParams.toString());
        }
        return var1_1;
    }
}

