/*
 * Decompiled with CFR 0.152.
 */
package weka.experiment;

import java.io.File;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.experiment.Experiment;
import weka.experiment.Task;
import weka.experiment.TaskStatusInfo;

public class RemoteExperimentSubTask
implements Task,
RevisionHandler {
    private TaskStatusInfo m_result = new TaskStatusInfo();
    private Experiment m_experiment;

    public RemoteExperimentSubTask() {
        this.m_result.setStatusMessage("Not running.");
        this.m_result.setExecutionStatus(0);
    }

    public void setExperiment(Experiment task) {
        this.m_experiment = task;
    }

    public Experiment getExperiment() {
        return this.m_experiment;
    }

    @Override
    public void execute() {
        this.m_result = new TaskStatusInfo();
        this.m_result.setStatusMessage("Running...");
        String goodResult = "(sub)experiment completed successfully";
        String subTaskType = this.m_experiment.getRunLower() != this.m_experiment.getRunUpper() ? "(dataset " + ((File)this.m_experiment.getDatasets().elementAt(0)).getName() : "(exp run # " + this.m_experiment.getRunLower();
        try {
            System.err.println("Initializing " + subTaskType + ")...");
            this.m_experiment.initialize();
            System.err.println("Iterating " + subTaskType + ")...");
            while (this.m_experiment.hasMoreIterations()) {
                this.m_experiment.nextIteration();
            }
            System.err.println("Postprocessing " + subTaskType + ")...");
            this.m_experiment.postProcess();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String badResult = "(sub)experiment " + subTaskType + ") failed : " + ex.toString();
            this.m_result.setExecutionStatus(2);
            this.m_result.setStatusMessage(badResult);
            this.m_result.setTaskResult("Failed");
            return;
        }
        this.m_result.setExecutionStatus(3);
        this.m_result.setStatusMessage(String.valueOf(goodResult) + " " + subTaskType + ").");
        this.m_result.setTaskResult("No errors");
    }

    @Override
    public TaskStatusInfo getTaskStatus() {
        return this.m_result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.10 $");
    }
}

