/*
 * Decompiled with CFR 0.152.
 */
package jdistlib;

import jdistlib.generic.GenericDistribution;
import jdistlib.math.MathFunctions;
import jdistlib.rng.RandomEngine;

public class Logistic
extends GenericDistribution {
    protected double location;
    protected double scale;

    public static final double density(double x, double location, double scale, boolean give_log) {
        if (Double.isNaN(x) || Double.isNaN(location) || Double.isNaN(scale)) {
            return x + location + scale;
        }
        if (scale <= 0.0) {
            return Double.NaN;
        }
        x = Math.abs((x - location) / scale);
        double e = Math.exp(-x);
        double f = 1.0 + e;
        return give_log ? -(x + Math.log(scale * f * f)) : e / (scale * f * f);
    }

    private static final double log1pexp(double x) {
        if (x <= 18.0) {
            return Math.log1p(Math.exp(x));
        }
        if (x > 33.3) {
            return x;
        }
        return x + Math.exp(-x);
    }

    public static final double cumulative(double x, double location, double scale, boolean lower_tail, boolean log_p) {
        if (Double.isNaN(x) || Double.isNaN(location) || Double.isNaN(scale)) {
            return x + location + scale;
        }
        if (scale <= 0.0) {
            return Double.NaN;
        }
        if (Double.isNaN(x = (x - location) / scale)) {
            return Double.NaN;
        }
        if (MathFunctions.isInfinite(x)) {
            if (x > 0.0) {
                return lower_tail ? (log_p ? 0.0 : 1.0) : (log_p ? Double.NEGATIVE_INFINITY : 0.0);
            }
            return lower_tail ? (log_p ? Double.NEGATIVE_INFINITY : 0.0) : (log_p ? 0.0 : 1.0);
        }
        return log_p ? -Logistic.log1pexp(lower_tail ? -x : x) : 1.0 / (1.0 + Math.exp(lower_tail ? -x : x));
    }

    public static final double quantile(double p, double location, double scale, boolean lower_tail, boolean log_p) {
        if (Double.isNaN(p) || Double.isNaN(location) || Double.isNaN(scale)) {
            return p + location + scale;
        }
        if (log_p) {
            if (p > 0.0) {
                return Double.NaN;
            }
            if (p == 0.0) {
                return lower_tail ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
            }
            if (p == Double.NEGATIVE_INFINITY) {
                return lower_tail ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
        } else {
            if (p < 0.0 || p > 1.0) {
                return Double.NaN;
            }
            if (p == 0.0) {
                return lower_tail ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
            if (p == 1.0) {
                return lower_tail ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
            }
        }
        if (scale < 0.0) {
            return Double.NaN;
        }
        if (scale == 0.0) {
            return location;
        }
        p = log_p ? (lower_tail ? (p -= p > -0.6931471805599453 ? Math.log(-Math.expm1(p)) : Math.log1p(-Math.exp(p))) : (p > -0.6931471805599453 ? Math.log(-Math.expm1(p)) : Math.log1p(-Math.exp(p))) - p) : Math.log(lower_tail ? p / (1.0 - p) : (1.0 - p) / p);
        return location + scale * p;
    }

    public static final double random(double location, double scale, RandomEngine random) {
        if (Double.isNaN(location) || MathFunctions.isInfinite(scale)) {
            return Double.NaN;
        }
        if (scale == 0.0 || MathFunctions.isInfinite(location)) {
            return location;
        }
        double u = random.nextDouble();
        return location + scale * Math.log(u / (1.0 - u));
    }

    public static final double[] random(int n, double location, double scale, RandomEngine random) {
        double[] rand = new double[n];
        int i = 0;
        while (i < n) {
            rand[i] = Logistic.random(location, scale, random);
            ++i;
        }
        return rand;
    }

    public Logistic() {
        this(0.0, 1.0);
    }

    public Logistic(double location, double scale) {
        this.location = location;
        this.scale = scale;
    }

    public double density(double x, boolean log) {
        return Logistic.density(x, this.location, this.scale, log);
    }

    public double cumulative(double p, boolean lower_tail, boolean log_p) {
        return Logistic.cumulative(p, this.location, this.scale, lower_tail, log_p);
    }

    public double quantile(double q, boolean lower_tail, boolean log_p) {
        return Logistic.quantile(q, this.location, this.scale, lower_tail, log_p);
    }

    public double random() {
        return Logistic.random(this.location, this.scale, this.random);
    }
}

