% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{HCAHPS2022}
\alias{HCAHPS2022}
\title{Nested and multivariate survey measures of hospital patient experience
and other measures}
\format{
A data frame with 53 rows and 14 columns\tabular{lll}{
   \verb{[,1]} \tab \code{State} \tab Unique identifier for each U.S. state/territory, see \url{https://npiregistry.cms.hhs.gov/help-api/state} \cr
   \verb{[,2]} \tab \code{Region} \tab The region nesting states and territories, according to the U.S. Census Bureau \cr
   \verb{[,3]} \tab \verb{Communication with Nurses} \tab Composite measure (3 questions) for nurse communication with patient (e.g., "During this hospital stay, how often did nurses listen carefully to you?") \cr
   \verb{[,4]} \tab \verb{Communication with Doctors} \tab Composite measure (3 questions) for doctor communication with patient (e.g., "During this hospital stay, how often did doctors explain things in a way you could understand?") \cr
   \verb{[,5]} \tab \verb{Responsiveness of Hospital Staff} \tab Composite measure (2 questions) for responsiveness of hospital staff (e.g., How often did you get help in getting to the bathroom or in using a bedpan as soon as you wanted?) \cr
   \verb{[,6]} \tab \verb{Communication About Medicines} \tab Composite measure (2 questions) for healthcare provider communication about medicines (e.g., Before giving you any new medicine, how often did hospital staff tell you what the medicine was for?) \cr
   \verb{[,7]} \tab \verb{Cleanliness of Hospital Environment} \tab Individual item: "During this hospital stay, how often were your room and bathroom kept clean?" \cr
   \verb{[,8]} \tab \verb{Quietness of Hospital Environment} \tab Individual item: "During this hospital stay, how often was the area around your room quiet at night?" \cr
   \verb{[,9]} \tab \verb{Discharge Information} \tab Composite measure (2 questions) for communication about care needed after leaving the hospital (e.g., was help needed after leaving the hospital discussed?) \cr
   \verb{[,10]} \tab \verb{Care Transition} \tab Composite measure (3 questions) for understanding of care needed (e.g., "When I left the hospital, I had a good understanding of the things I was responsible for in managing my health?") \cr
   \verb{[,11]} \tab \verb{Hospital Rating} \tab Ten point Likert scale rating of hospital (worse possible to best possible) \cr
   \verb{[,12]} \tab \verb{Recommend the Hospital} \tab Individual item: "Would you recommend this hospital...?" Percent of "yes" responses \cr
   \verb{[,13]} \tab \verb{Participating Hospitals} \tab Number of participating hospitals in the region \cr
   \verb{[,14]} \tab \verb{Survey Response Rate} \tab Patient survey response rate for each state/territory (\%) \cr
}
}
\source{
CAHPS Hospital Survey (2022).
HCAHPS Survey Results Table (Dataset)
\url{https://www.hcahpsonline.org/globalassets/hcahps/summary-analyses/summary-results/april-2023-public-report-july-2021---june-2022-discharges.pdf}
}
\usage{
HCAHPS2022
}
\description{
A summary dataset from non-independent units of analysis (six
regions nesting 50 U.S. states and 3 U.S. territories) with multivariate
(composite) measures. This is a survey assessing patient experience for
hospitalized care, the Hospital Consumer Assessment of Healthcare Providers
and Systems (HCAHPS) Survey; also referred to as the CAHPS® Hospital Survey.
The data were publicly released in April 2023 by the U.S. Centers for
Medicare & Medicaid Services (CMS).

HCAHPS is a standardized and validated survey instrument for evaluating
patient experience. Patient experience is an indicator of healthcare quality
and is defined as the "... range of interactions at patients have with the
healthcare system, including their care from health plans, and from doctors,
nurses, and staff in hospitals..."  \url{https://www.ahrq.gov/cahps/about-cahps/patient-experience/index.html}.

The HCAHPS composite measures consist of multiple questions and, here, are top box scores (see \url{https://www.hcahpsonline.org/en/summary-analyses/}).
In addition to patient experience, there are additional measures such as whether the hospital is
recommended or not, the number or participating hospitals, and the survey response rate
\itemize{
\item Note this is \emph{not} a representative sample
\item Measures are averaged at the state/territory level
\item Respondents were discharged from a hospital between July 2021 to July 2022
\item Results are patient-mix adjusted, see \doi{https://doi.org/10.1111/j.1475-6773.2008.00914.x}
}

Additional Information:
\itemize{
\item For details about the data and questions comprising composite measures, see
\url{https://www.hcahpsonline.org/globalassets/hcahps/star-ratings/tech-notes/april_2023_star-ratings_tech_notes.pdf}
\item For the specific questions on the HCAHPS survey,
see \url{https://www.hcahpsonline.org/globalassets/hcahps/quality-assurance/2023_survey-instruments_english_mail.pdf}
\item CAHPS® is a registered trademark of the U.S. Agency for Healthcare Research
and Quality: \url{https://www.ahrq.gov/cahps/about-cahps/using-cahps-name/index.html}
}
}
