% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimulateMDCEV.R
\name{SimulateMDCEV}
\alias{SimulateMDCEV}
\title{SimulateMDCEV}
\usage{
SimulateMDCEV(df_indiv, df_common, sim_options, sim_type = c("welfare",
  "demand"), nerrs = 30, cond_error = 1, draw_mlhs = 1,
  algo_gen = NULL, tol = 1e-20, max_loop = 999)
}
\arguments{
\item{df_indiv}{Prepared individual level data from PrepareSimulationData}

\item{df_common}{Prepared common data from PrepareSimulationData}

\item{sim_options}{Prepared simulation options from PrepareSimulationData}

\item{sim_type}{Either "welfare" or "demand"}

\item{nerrs}{Number of error draws for welfare analysis}

\item{cond_error}{Choose whether to draw errors conditional on actual demand or not.
Conditional error draws (=1) or unconditional error draws.}

\item{draw_mlhs}{Generate draws using Modified Latin Hypercube Sampling algorithm (=1)
or uniform (=0)}

\item{algo_gen}{Type of algorhitm for simulation. algo_gen = 0 for Hybrid Approach (i.e. constant alphas,
only model 3/4) alog_gen = 1 for General approach (i.e. heterogeneous alpha's, all models)}

\item{tol}{Tolerance level for simulations if using general approach}

\item{max_loop}{maximum number of loops for simulations if using general approach}
}
\value{
wtp a list for each individual holding a nsims x npols matrix of wtp
}
\description{
Simulate welfare or demand for MDCEV model
}
\examples{
\donttest{
data(data_rec, package = "rmdcev")
mdcev_est <- FitMDCEV(psi_formula = ~ 1,
data = subset(data_rec, id < 500),
model = "hybrid0",
algorithm = "MLE")

policies <- CreateBlankPolicies(npols = 2,
ngoods = mdcev_est[["stan_data"]][["J"]],
dat_psi = mdcev_est[["stan_data"]][["dat_psi"]],
price_change_only = TRUE)

df_sim <- PrepareSimulationData(mdcev_est, policies)

wtp <- SimulateMDCEV(df_sim$df_indiv,
df_common = df_sim$df_common,
sim_options = df_sim$sim_options,
cond_err = 1, nerrs = 5, sim_type = "welfare")
}
}
