% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parallel.R
\name{loop}
\alias{loop}
\title{Apply an rmonad pipeline function to each element in a rmonad bound list}
\usage{
loop(m, FUN, looper = lapply, ...)
}
\arguments{
\item{m}{Rmonad object wrapping a vector}

\item{FUN}{function of an element from the vector stored in \code{m} that
returns an Rmonad object.}

\item{looper}{function that applies each element in the input vector to
\code{FUN}. The default it \code{lapply}.}

\item{...}{Additional arguments sent to \code{FUN}}
}
\value{
Rmonad object wrapping a vector of the values wrapped by the outputs
of \code{FUN}
}
\description{
Apply an rmonad pipeline function to each element in a rmonad bound list
}
\examples{
foo <- function(x) { x \%>>\% sqrt }
c(256, 6561) \%v>\% sqrt \%>\% loop(foo) \%>>\% lapply(sqrt)
}
