% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{heat_map}
\alias{heat_map}
\title{Heatmap Plots}
\usage{
heat_map(fitness)
}
\arguments{
\item{fitness}{An matrix of values representing the fitness of the objective
values of nsga-class, nsga2-class or nsga3-class.
See \linkS4class{nsga}, \linkS4class{nsga2} or \linkS4class{nsga3} for a description of
available slots information.}
}
\description{
The \code{heat_map()} function for hyperdimensional data
visualization, which shows magnitude of a phenomenon as color in two
dimension.
}
\examples{
#Four Objectives Plotting
dtlz1 <- function (x, nobj = 4){
    if (is.null(dim(x))) {
        x <- matrix(x, 1)
    }
    n <- ncol(x)
    y <- matrix(x[, 1:(nobj - 1)], nrow(x))
    z <- matrix(x[, nobj:n], nrow(x))
    g <- 100 * (n - nobj + 1 + rowSums((z - 0.5)^2 - cos(20 * pi * (z - 0.5))))
    tmp <- t(apply(y, 1, cumprod))
    tmp <- cbind(t(apply(tmp, 1, rev)), 1)
    tmp2 <- cbind(1, t(apply(1 - y, 1, rev)))
    f <- tmp * tmp2 * 0.5 * (1 + g)
    return(f)
}

#Not Run
\dontrun{
result <- nsga3(type = "real-valued",
                fitness = dtlz1,
                lower = rep(0,4),
                upper = rep(1,4),
                popSize = 92,
                n_partitions = 12,
                monitor = FALSE,
                maxiter = 500)
}
#Not Run
\dontrun{
heat_map(fitness = result@fitness)
}

}
\author{
Francisco Benitez
\email{benitezfj94@gmail.com}
}
