% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.contrast.r
\name{plot.contrast.rms}
\alias{plot.contrast.rms}
\title{plot.contrast.rms}
\usage{
\method{plot}{contrast.rms}(
  x,
  bivar = FALSE,
  bivarmethod = c("ellipse", "kernel"),
  prob = 0.95,
  which = c("both", "diff", "ind"),
  nrow = NULL,
  ncol = NULL,
  ...
)
}
\arguments{
\item{x}{the result of \code{contrast.rms}}

\item{bivar}{set to \code{TRUE} to plot 2-d posterior density contour}

\item{bivarmethod}{see \code{pdensityCountour}}

\item{prob}{posterior coverage probability for HPD interval or 2-d contour}

\item{which}{applies when plotting the result of \code{contrast(..., fun=)}, defaulting to showing the posterior density of both estimates plus their difference.  Set to \code{"ind"} to only show the two individual densities or \code{"diff"} to only show the posterior density for the differences.}

\item{nrow}{for \code{ggplot2::facet_wrap}}

\item{ncol}{likewise}

\item{...}{unused}
}
\value{
\code{ggplot2} object
}
\description{
Plot Bayesian Contrast Posterior Densities
}
\details{
If there are exactly two contrasts and \code{bivar=TRUE} plots an elliptical or kernal (based on \code{bivarmethod} posterior density contour with probability \code{prob}).  Otherwise plots a series of posterior densities of contrasts along with HPD intervals, posterior means, and medians.  When the result being plotted comes from \code{contrast} with \code{fun=} specified, both the two individual estimates and their difference are plotted.
}
\author{
Frank Harrell
}
