% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poma.r
\name{poma}
\alias{poma}
\title{Examine proportional odds and parallelism assumptions of `orm` and `lrm` model fits.}
\usage{
poma(mod.orm, cutval)
}
\arguments{
\item{mod.orm}{Model fit of class `orm` or `lrm`. For `fit.mult.impute` objects, `poma` will refit model on a singly-imputed data-set}

\item{cutval}{Numeric vector; sequence of observed values to cut outcome}
}
\description{
Based on codes and strategies from Frank Harrell's canonical `Regression Modeling Strategies` text
}
\details{
Strategy 1: Apply different link functions to Prob of Binary Ys (defined by cutval). Regress transformed outcome on combined X and assess constancy of slopes (betas) across cut-points \cr
Strategy 2: Generate score residual plot for each predictor (for response variable with <10 unique levels) \cr
Strategy 3: Assess parallelism of link function transformed inverse CDFs curves for different XBeta levels (for response variables with >=10 unique levels)
}
\examples{

## orm model (response variable has fewer than 10 unique levels)
mod.orm <- orm(carb ~ cyl + hp , x=TRUE, y=TRUE, data = mtcars)
poma(mod.orm)


## orm model (response variable has >=10 unique levels)
mod.orm <- orm(mpg ~ cyl + hp , x=TRUE, y=TRUE, data = mtcars)
poma(mod.orm)


## orm model using imputation
dat <- mtcars
## introduce NAs
dat[sample(rownames(dat), 10), "cyl"] <- NA
im <- aregImpute(~ cyl + wt + mpg + am, data = dat)
aa <- fit.mult.impute(mpg ~ cyl + wt , xtrans = im, data = dat, fitter = orm)
poma(aa)
}
\seealso{
Harrell FE. *Regression Modeling Strategies: with applications to linear models,
logistic and ordinal regression, and survival analysis.* New York: Springer Science, LLC, 2015.
}
\author{
Yong Hao Pua <puayonghao@gmail.com>
}
