% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmw_find_breakpoints.R
\name{rmw_find_breakpoints}
\alias{rmw_find_breakpoints}
\title{Function to detect breakpoints in a data frame using a linear regression 
based approach.}
\usage{
rmw_find_breakpoints(df, h = 0.15, n = NULL)
}
\arguments{
\item{df}{Data frame from \code{\link{rmw_normalise}} to detect breakpoints 
in.}

\item{h}{Minimal segment size either given as fraction relative to the sample 
size or as an integer giving the minimal number of observations in each 
segment.}

\item{n}{Number of breaks to detect. Default is maximum number allowed by
\code{h}.}
}
\value{
Data frame with a \code{date} variable indicating where the 
breakpoints are.
}
\description{
\code{rmw_find_breakpoints} will generally be applied to a data frame after
\code{\link{rmw_normalise}}. \code{rmw_find_breakpoints} is rather slow.
}
\examples{

# Test for breakpoints in an example normalised time series
data_breakpoints <- rmw_find_breakpoints(data_london_normalised)

}
\author{
Stuart K. Grange
}
