% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmw_partial_dependencies.R
\name{rmw_partial_dependencies}
\alias{rmw_partial_dependencies}
\title{Function to calculate partial dependencies after training with 
\strong{rmweather}.}
\usage{
rmw_partial_dependencies(
  model,
  df,
  variable,
  training_only = TRUE,
  resolution = NULL,
  n_cores = NA,
  verbose = FALSE
)
}
\arguments{
\item{model}{A ranger model object from \code{\link{rmw_train_model}}.}

\item{df}{Input data frame after preparation with 
\code{\link{rmw_prepare_data}}.}

\item{variable}{Vector of variables to calculate partial dependencies for.}

\item{training_only}{Should only the training set be used for prediction? The
default is \code{TRUE}.}

\item{resolution}{The number of points that should be predicted for each 
independent variable. If left as \code{NULL}, a default sequence will be 
generated. See \code{\link{partial}} for details.}

\item{n_cores}{Number of CPU cores to use for the model calculation. The 
default is system's total minus one.}

\item{verbose}{Should the function give messages?}
}
\value{
Tibble.
}
\description{
\code{rmw_plot_partial_dependencies} is rather slow.
}
\examples{

\donttest{

# Load packages
library(dplyr)
# Ranger package needs to be loaded
library(ranger)

# Prepare example data
data_london_prepared <- data_london \%>\% 
  filter(variable == "no2") \%>\% 
  rmw_prepare_data()

# Calculate partial dependencies for wind speed
data_partial <- rmw_partial_dependencies(
  model = model_london, 
  df = data_london_prepared, 
  variable = "ws", 
  verbose = TRUE
)

# Calculate partial dependencies for all independent variables used in model
data_partial <- rmw_partial_dependencies(
  model = model_london, 
  df = data_london_prepared, 
  variable = NA, 
  verbose = TRUE
)

}

}
\author{
Stuart K. Grange
}
