% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/request.R
\name{nassqs}
\alias{nassqs}
\title{Get data and return a data frame}
\usage{
nassqs(..., as = c("data.frame", "text", "list"))
}
\arguments{
\item{...}{either a named list of parameters or a series of parameters to
form the query}

\item{as}{whether to return a data.frame, list, or text string
\code{\link[=nassqs_GET]{nassqs_GET()}}}
}
\value{
a data frame, list, or text string of requested data.
}
\description{
The primary function in the \code{rnassqs} package, \code{nassqs} makes a HTTP GET
request to the USDA-NASS Quick Stats API and returns the data parsed as a
data.frame, plain text, or list. Various other functions make use of \code{nassqs}
to make specific queries. For a data request the Quick Stats API returns
JSON that when parsed to a data.frame contains 39 columns and a varying
number of rows depending on the query. Unfortunately there is not a way to
restrict the number of columns.
}
\examples{
\donttest{
  # Get corn yields in Virginia in 2012
  params <- list(commodity_name = "CORN",
                 year = 2012,
                 agg_level_desc = "COUNTY",
                 state_alpha = "VA",
                 statisticcat_desc = "YIELD")
  yields <- nassqs(params)
  head(yields)
}
}
\seealso{
\code{\link[=nassqs_GET]{nassqs_GET()}}, \code{\link[=nassqs_yields]{nassqs_yields()}}, \code{\link[=nassqs_acres]{nassqs_acres()}}
}
