% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run.series.meta_function.R
\name{run_series_meta}
\alias{run_series_meta}
\title{Perform a series of Bayesian pairwise meta-analyses}
\usage{
run_series_meta(full, n_chains, n_iter, n_burnin, n_thin)
}
\arguments{
\item{full}{An object of S3 class \code{\link{run_model}}. See 'Value' in
\code{\link{run_model}}.}

\item{n_chains}{Integer specifying the number of chains for the MCMC
sampling; an argument of the \code{\link[R2jags]{jags}} function of the
R-package \href{https://CRAN.R-project.org/package=R2jags}{R2jags}.
The default argument is 2.}

\item{n_iter}{Positive integer specifying the number of Markov chains for the
MCMC sampling; an argument of the \code{\link[R2jags]{jags}} function of
the R-package \href{https://CRAN.R-project.org/package=R2jags}{R2jags}.
The default argument is 10000.}

\item{n_burnin}{Positive integer specifying the number of iterations to
discard at the beginning of the MCMC sampling; an argument of the
\code{\link[R2jags]{jags}} function of the R-package
\href{https://CRAN.R-project.org/package=R2jags}{R2jags}.
The default argument is 1000.}

\item{n_thin}{Positive integer specifying the thinning rate for the MCMC
sampling; an argument of the \code{\link[R2jags]{jags}} function of the
R-package \href{https://CRAN.R-project.org/package=R2jags}{R2jags}.
The default argument is 1.}
}
\value{
An R2jags output on the summaries of the posterior distribution, and
  the Gelman-Rubin convergence diagnostic of the following monitored
  parameters:
  \tabular{ll}{
   \code{EM} \tab The summary effect estimate (according to the argument
   \code{measure} defined in \code{\link{run_model}}) of each observed
   pairwise comparison with at least two trials in the network.\cr
   \tab \cr
   \code{tau} \tab The between-trial standard deviation for pairwise
   comparisons with at least two trials, when the random-effects model has
   been specified.\cr
  }
}
\description{
Performs a Bayesian pairwise meta-analysis for each
 pairwise comparison with at least two trials in the network.
}
\details{
\code{run_series_meta} inherits the arguments \code{data},
  \code{measure}, \code{model}, \code{assumption}, \code{heter_prior},
  \code{mean_misspar}, and \code{var_misspar} from \code{\link{run_model}}
  (now contained in the argument \code{full}). This prevents specifying
  a different Bayesian model from that considered in \code{\link{run_model}}.
  Therefore, the user needs first to apply \code{\link{run_model}}, and then
  use \code{run_series_meta} (see 'Examples').

  \code{run_series_meta} runs a series of Bayesian pairwise meta-analyses
  in \code{JAGS}. The progress of the simulation appears on the R console.
  The number of times a pairwise meta-analysis is preformed is also printed
  on the console (in red) and is equal to the number of  pairwise comparisons
  observed in the network (see 'Examples').

  The output of \code{run_series_meta} is not end-user-ready. The
  \code{\link{series_meta_plot}} function uses the output of
  \code{run_series_meta} as an S3 object and processes it further to provide
  an end-user-ready output.

  \code{run_series_meta} can be used only for a network of interventions.
  In the case of two interventions, the execution of the function will
  be stopped and an error message will be printed on the R console.
}
\examples{
data("nma.dogliotti2014")

# Show the first six trials of the dataset (one-trial-per-row format)
head(nma.dogliotti2014)

# Read results from 'run_model' (using the default arguments)
res <- readRDS(system.file('extdata/res_dogliotti.rds', package = 'rnmamod'))

\donttest{
# Run separate random-effects pairwise meta-analyses
# Note: Ideally, set 'n_iter' to 10000 and 'n_burnin' to 1000
run_series_meta(full = res,
                n_chains = 3,
                n_iter = 1000,
                n_burnin = 100,
                n_thin = 1)
}

}
\references{
Gelman A, Rubin DB. Inference from iterative simulation using multiple
sequences. \emph{Stat Sci} 1992;\bold{7}:457--472.
}
\seealso{
\code{\link[R2jags]{jags}}, \code{\link{run_model}},
  \code{\link{series_meta_plot}},
}
\author{
{Loukia M. Spineli}
}
