% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/balloon.plot.mod_function.R
\name{balloon_plot}
\alias{balloon_plot}
\title{Enhanced balloon plot}
\usage{
balloon_plot(sens, compar, drug_names)
}
\arguments{
\item{sens}{An object of S3 class \code{\link{run_sensitivity}}.
See 'Value' in \code{\link{run_sensitivity}}.}

\item{compar}{A character vector with two elements indicating the pairwise
comparison of interest. The first element refers to the 'experimental'
and the second element to the 'control' intervention of the comparison.}

\item{drug_names}{A vector of labels with the name of the interventions
in the order they appear in the argument \code{data} of
\code{\link{run_model}}.}
}
\value{
\code{balloon_plot} returns two enhanced balloon plots for one
  comparison (see 'Details'):
  \item{plot_effect_size}{The enhanced balloon plot for the
  summary effect size (according to the argument \code{measure} inherited
  by \code{\link{run_sensitivity}}) for one pairwise comparison.}
  \item{plot_tau}{The enhanced balloon plot for \emph{tau}. When the
  fixed-effect model has been performed in \code{\link{run_sensitivity}},
  the function will not return the \code{plot_tau}.}
}
\description{
Creates the enhanced balloon plot for the summary effect size and
  between-trial standard deviation, \emph{tau}, under different scenarios
  about the missingness parameter for a pair of interventions.
  \code{balloon_plot} uses the scenarios considered in
  \code{\link{run_sensitivity}}.
}
\details{
For the \code{plot_effect_size} of the selected pairwise comparison,
  the different colours and sizes of the bubbles reflect the
  posterior standard deviation and the posterior mean, respectively.
  A colour key appears below the plot.
  The size of the bubble is proportional to the corresponding posterior mean.
  Crossed bubbles indicate scenarios with conclusive evidence (the
  95\% credible interval excludes the null value), and filled bubbles
  indicate scenarios with inconclusive evidence (the 95\% credible interval
  includes the null value). The missing-at-random assumption (primary
  analysis) is labeled in a white frame.
  Both axes illustrate the scenarios as specified in the argument
  \code{mean_scenarios} of the \code{\link{run_sensitivity}}:
  the x-axis refers to the 'experimental' intervention, and the y-axis refers
  to the 'control' intervention.

  The same enhanced balloon plot is created for \emph{tau} (\code{plot_tau}).
  However, filled bubbles indicate low statistical heterogeneity
  (the posterior median of \emph{tau} is lower than the median of the
  prior distribution for the heterogeneity parameter),
  and crossed bubbles indicate considerable statistical heterogeneity
  (the posterior median of \emph{tau} exceeds the median of the prior
  distribution for the heterogeneity parameter).

  \code{balloon_plot} can be used only when missing participant
  outcome data have been extracted for at least one trial.
  Otherwise, the execution of the function will be stopped and an error
  message will be printed on the R console.
}
\examples{
data("pma.taylor2004")

# Read results from 'run_sensitivity' (using the default arguments)
res_sens <- readRDS(system.file('extdata/res_sens_taylor.rds',
                    package = 'rnmamod'))

# The names of the interventions in the order they appear in the dataset
interv_names <- c("placebo", "inositol")

# Create the enhanced balloon plot for 'inositol versus placebo'
balloon_plot(sens = res_sens,
             compar = c("inositol", "placebo"),
             drug_names = interv_names)

}
\references{
Spineli LM, Kalyvas C, Papadimitropoulou K. Quantifying the robustness of
primary analysis results: A case study on missing outcome data in pairwise
and network meta-analysis. \emph{Res Synth Methods}
2021;\bold{12}(4):475--490. doi: https://doi.org/10.1002/jrsm.1478
}
\seealso{
\code{\link{run_model}}, \code{\link{run_sensitivity}}
}
\author{
{Loukia M. Spineli}
}
