% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isd_read.R
\name{isd_read}
\alias{isd_read}
\title{Read NOAA ISD/ISH local file}
\usage{
isd_read(path)
}
\arguments{
\item{path}{(character) path to the file. required.}
}
\value{
A tibble (data.frame)
}
\description{
Read NOAA ISD/ISH local file
}
\details{
\code{isd_read} - read a \code{.gz} file as downloaded
from NOAA's website
}
\examples{
\dontrun{
file <- system.file("examples", "011490-99999-1986.gz", package = "rnoaa")
isd_read(file)
}
}
\references{
ftp://ftp.ncdc.noaa.gov/pub/data/noaa/
}
\seealso{
\code{\link{isd}}, \code{\link{isd_stations}},
\code{\link{isd_stations_search}}

Other isd: \code{\link{isd_stations_search}},
  \code{\link{isd_stations}}, \code{\link{isd}}
}

