% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biplot.pcaCoDa.R
\name{biplot.pcaCoDa}
\alias{biplot.pcaCoDa}
\title{Biplot method}
\usage{
\method{biplot}{pcaCoDa}(x, y, ...)
}
\arguments{
\item{x}{object of class \sQuote{pcaCoDa}}

\item{y}{...}

\item{\dots}{arguments passed to plot methods}
}
\value{
The robust compositional biplot.
}
\description{
Provides robust compositional biplots.
}
\details{
The robust compositional biplot according to Aitchison and Greenacre (2002),
computed from (robust) loadings and scores resulting from \code{\link{pcaCoDa}}, is performed.
}
\examples{

data(coffee)
p1 <- pcaCoDa(coffee[,-1])
p1
biplot(p1)


## with labels for the scores:
data(arcticLake)
rownames(arcticLake) <- paste(sample(letters[1:26], nrow(arcticLake), replace=TRUE), 
                              1:nrow(arcticLake), sep="")
pc <- pcaCoDa(arcticLake, method="classical")
biplot(pc, xlabs=rownames(arcticLake))


}
\author{
M. Templ, K. Hron
}
\references{
Aitchison, J. and Greenacre, M. (2002). Biplots of compositional
data. \emph{Applied Statistics}, \bold{51}, 375-392. \

Filzmoser, P., Hron, K., Reimann, C. (2009) Principal Component Analysis for
Compositional Data with Outliers. \emph{Environmetrics}, \bold{20} (6),
621--632.
}
\seealso{
\code{\link{pcaCoDa}}, \code{\link{plot.pcaCoDa}}
}
\keyword{aplot}

