% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compareMahal.R
\name{compareMahal}
\alias{compareMahal}
\alias{getEstimates}
\alias{print.estimates}
\alias{plot.estimates}
\alias{plot.mahal}
\title{Compares Mahalanobis distances from two approaches}
\usage{
compareMahal(x, imp = "KNNa")

\method{plot}{mahal}(x, y, ...)
}
\arguments{
\item{x}{data frame or matrix}

\item{imp}{imputation method}

\item{y}{unused second argument for the plot method}

\item{...}{additional arguments for plotting passed through}
}
\value{
\item{df}{a data.frame containing the Mahalanobis distances from the estimation in subgroups, the Mahalanobis distances from the imputation and covariance approach, an indicator specifiying outliers and an indicator specifying the zero pattern} \item{df2}{a groupwise statistics.}
}
\description{
Mahalanobis distances are calculated for each zero pattern.
Two approaches are used. The first one estimates Mahalanobis distance for observations belonging to one each zero pattern each.
The second method uses a more sophisticated approach described below.
}
\examples{

data(arcticLake)
# generate some zeros
arcticLake[1:10, 1] <- 0
arcticLake[11:20, 2] <- 0
m <- compareMahal(arcticLake)
plot(m)
}
\references{
M. Templ, K. Hron, P. Filzmoser. 
Exploratory Tools for Outlier Detection in Compositional Data with Structural Zeros".
\emph{Journal of Applied Statistics}, \strong{44} (4), 734--752, 2017
}
\seealso{
\code{\link{impKNNa}}, \code{\link{pivotCoord}}
}
\author{
Matthias Templ, Karel Hron
}
