% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rt_request_handler.R,
%   R/rt_request_handler_defaults.R
\docType{data}
\name{rt_request_handler}
\alias{rt_request_handler}
\alias{on_server_error_default}
\alias{on_client_error_default}
\alias{on_not_found_default}
\alias{on_redirect_default}
\alias{on_domain_change_default}
\alias{on_sub_domain_change_default}
\alias{on_file_type_mismatch_default}
\alias{on_suspect_content_default}
\title{rt_request_handler}
\format{An object of class \code{list} of length 4.}
\usage{
rt_request_handler(
  request,
  on_server_error = on_server_error_default,
  on_client_error = on_client_error_default,
  on_not_found = on_not_found_default,
  on_redirect = on_redirect_default,
  on_domain_change = on_domain_change_default,
  on_sub_domain_change = on_sub_domain_change_default,
  on_file_type_mismatch = on_file_type_mismatch_default,
  on_suspect_content = on_suspect_content_default,
  warn = TRUE,
  encoding = "UTF-8"
)

on_server_error_default

on_client_error_default

on_not_found_default

on_redirect_default

on_domain_change_default

on_sub_domain_change_default

on_file_type_mismatch_default

on_suspect_content_default
}
\arguments{
\item{request}{result of an HTTP request (e.g. httr::GET())}

\item{on_server_error}{request state handler for any 5xx status}

\item{on_client_error}{request state handler for any 4xx HTTP status that is
not 404}

\item{on_not_found}{request state handler for HTTP status 404}

\item{on_redirect}{request state handler for any 3xx HTTP status}

\item{on_domain_change}{request state handler for any 3xx HTTP status where
domain did change as well}

\item{on_sub_domain_change}{request state handler for any 3xx HTTP status where
domain did change but only to www-sub_domain}

\item{on_file_type_mismatch}{request state handler for content type other
than 'text/plain'}

\item{on_suspect_content}{request state handler for content that seems to be
something else than a robots.txt file (usually a JSON, XML or HTML)}

\item{warn}{suppress warnings}

\item{encoding}{The text encoding to assume if no encoding is provided in the
headers of the response}
}
\value{
a list with three items following the following schema: \cr \code{
  list( rtxt = "", problems = list( "redirect" = list( status_code = 301 ),
  "domain" = list(from_url = "...", to_url = "...") ) ) }
}
\description{
A helper function for get_robotstxt() that will extract the robots.txt file
from the HTTP request result object. furthermore it will inform
get_robotstxt() if the request should be cached and which problems occured.
}
\keyword{datasets}
