% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess.R
\name{controlled.mean.score}
\alias{controlled.mean.score}
\title{Compute Controlled Activation Score}
\usage{
controlled.mean.score(environment, genes, knn = 10,
  exclude.missing.genes = T, constrain.cell.universe = NA)
}
\arguments{
\item{environment}{\code{environment} object}

\item{genes}{gene list upon which to calculate gene signature activate}

\item{knn}{number of nearest neighbors}

\item{exclude.missing.genes}{whether to exclude genes with missing values}

\item{constrain.cell.universe}{binary vector indicating in which subset of cells to calculate the gene signature activation. Default is all cells.}
}
\value{
gene signature activation scores per cell
}
\description{
Compute mean gene signatures activation scores while controlling for technically similar genes.
}
\examples{
LCMV1 <- setup_LCMV_example()
exhaustion_markers <- c('Pdcd1', 'Cd244', 'Havcr2', 'Ctla4', 'Cd160', 'Lag3',
'Tigit', 'Cd96')
Exhaustion <- controlled.mean.score(LCMV1, exhaustion_markers)
}
