% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simiarlity.R
\name{get.robust.cluster.similarity}
\alias{get.robust.cluster.similarity}
\title{Get Robust Cluster Similarity}
\usage{
get.robust.cluster.similarity(environment, similarity,
  min.sd = stats::qnorm(0.95), max.q.val = 0.01, rerun = F)
}
\arguments{
\item{environment}{\code{environment} object}

\item{similarity}{pearson correlation between clusters' FC vectors defined in assess.cluster.similarity}

\item{min.sd}{minimum standard deviation for cluster reproducibility assessment}

\item{max.q.val}{maximum q value for cluster correlation cutoff}

\item{rerun}{whether to rerun the analysis or load from cache}
}
\value{
filtered cluster similarity matrix
}
\description{
Use cross-replicate experiment cluster similarity to remove irreproducible clusters.
}
\examples{
\donttest{
LCMV1 <- setup_LCMV_example()
LCMV1 <- get.variable.genes(LCMV1, min.mean = 0.1, min.frac.cells = 0,
min.dispersion.scaled = 0.1)
LCMV1 <- PCA(LCMV1)
LCMV1 <- cluster.analysis(LCMV1)
types = rbind(
data.frame(type='Tfh',gene=c('Tcf7','Cxcr5','Bcl6')),
data.frame(type='Th1',gene=c('Cxcr6','Ifng','Tbx21')),
data.frame(type='Tcmp',gene=c('Ccr7','Bcl2','Tcf7')),
data.frame(type='Treg',gene=c('Foxp3','Il2ra')),
data.frame(type='Tmem',gene=c('Il7r','Ccr7')),
data.frame(type='CD8',gene=c('Cd8a')),
data.frame(type='CD4', gene = c("Cd4")),
data.frame(type='Cycle',gene=c('Mki67','Top2a','Birc5'))
)
summarize(LCMV1)
cluster_names <- get.cluster.names(LCMV1, types, min.fold = 1.0, max.Qval = 0.01)
LCMV1 <- set.cluster.names(LCMV1, names = cluster_names)
LCMV2 <- setup_LCMV_example("LCMV2")
LCMV2 <- get.variable.genes(LCMV2, min.mean = 0.1, min.frac.cells = 0,
min.dispersion.scaled = 0.1)
LCMV2 <- PCA(LCMV2)
LCMV2 <- cluster.analysis(LCMV2)
summarize(LCMV2)
cluster_names <- get.cluster.names(LCMV2, types, min.fold = 1.0, max.Qval = 0.01)
LCMV2 <- set.cluster.names(LCMV2, names = cluster_names)
pooled_env <- setup_pooled_env()
pooled_env <- read.preclustered.datasets(pooled_env)
pooled_env <- PCA(pooled_env, clear.previously.calculated.clustering = F)
summarize(pooled_env, contrast = "datasets")
cluster.similarity <- assess.cluster.similarity(pooled_env)
similarity <- cluster.similarity$similarity
map <- cluster.similarity$map
filtered.similarity <- get.robust.cluster.similarity(
   pooled_env, similarity, min.sd = qnorm(.9), max.q.val = 0.01, rerun = F)
}
}
