% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processFile.R
\name{processDatasetsInParallel}
\alias{processDatasetsInParallel}
\title{Process Datasets in Parallel}
\usage{
processDatasetsInParallel(
  datasets,
  path,
  baseFilename,
  fittingFunctions,
  chunkSize,
  saveFitted = FALSE,
  checkProcessed = FALSE,
  createMinimalSaveFile = FALSE,
  ncores = 1,
  clusterType = "PSOCK",
  ...
)
}
\arguments{
\item{datasets}{dataset list generated by one of the generate functions.}

\item{path}{path to save the datasets to.}

\item{baseFilename}{filename to use, without extension.}

\item{fittingFunctions}{vector of \code{\link{fitDatasets}} functions that
should be applied to each dataset.}

\item{chunkSize}{number of datasets to process together in a single job.}

\item{saveFitted}{logical, if true, the raw fits are also stored.}

\item{checkProcessed}{logical, if true, will check whether the contents of
the processed output is reproduced for the first dataset. This is useful
to ensure that everything is still working as expected without having to
re-run the whole simulation study.}

\item{createMinimalSaveFile}{logical, if true, will create a file with the
processed results of the first three datasets. This is helpful if one
wants to store only the final aggregated results but still wants to make
sure that the full code works as expected.}

\item{ncores}{number of cores to use in processing, if set to 1, datasets
are processed in the current R session. Use
\code{\link[parallel]{detectCores}} to find out how many cores are
available on your machine.}

\item{clusterType}{type of cluster to be created, passed to
\code{\link[parallel]{makeCluster}}.}

\item{...}{passed on to \code{\link{processFit}}. Use this to control what
to save.}
}
\value{
The list of all processed results merged together.

  To help reproduciblility, the output of \code{toLatex(sessionInfo(),
  locale = FALSE)} is stored in the \code{sessionInfo} attribute.
}
\description{
Convenience function to run simulation study in parallel on a single
machine.
}
\details{
The merged results are saved in a file taking the name
\code{<path>/<baseFilename>-processed.Rdata}. You can delete the
intermediate result files with the numbers (the chunk index) in the name.

To run on multiple machines, use \code{\link{saveDatasets}} to save datasets
into multiple files. Then call \code{\link{processFile}} on each of them on
the designated machine. Finally, load and merge the results together using
\code{\link{loadAndMergePartialResults}}.
}
\seealso{
\code{\link{saveDatasets}}, \code{\link{processFile}}
}
\author{
Manuel Koller
}
