% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitDatasets.R
\name{createRhoFunction}
\alias{createRhoFunction}
\title{Create Rho-Functions With Custom Tuning Parameter}
\usage{
createRhoFunction(
  tuningParameter,
  which = c("rho.e", "rho.sigma.e", "rho.b.diagonal", "rho.sigma.b.diagonal",
    "rho.b.blockDiagonal", "rho.sigma.b.blockDiagonal"),
  rho.e = smoothPsi,
  rho.sigma.e = psi2propII(rho.e),
  rho.b.diagonal = rho.e,
  rho.sigma.b.diagonal = psi2propII(rho.b.diagonal),
  rho.b.blockDiagonal = rho.e,
  rho.sigma.b.blockDiagonal = rho.b.blockDiagonal,
  ...
)
}
\arguments{
\item{tuningParameter}{argument passed on to
\code{\link{extractTuningParameter}}. See its documentation for details.}

\item{which}{string specifiying which tuning parameter should be extracted.}

\item{rho.e}{\code{\link{PsiFunction}} to be used for \code{rho.e}.}

\item{rho.sigma.e}{\code{\link{PsiFunction}} to be used for
\code{rho.sigma.e}.}

\item{rho.b.diagonal}{\code{\link{PsiFunction}} to be used for \code{rho.b}
for models with diagonal random effects covariance matrix.}

\item{rho.sigma.b.diagonal}{\code{\link{PsiFunction}} to be used for
\code{rho.sigma.b} for models with diagonal random effects covariance
matrix.}

\item{rho.b.blockDiagonal}{\code{\link{PsiFunction}} to be used for
\code{rho.b} for models with block-diagonal random effects covariance
matrix.}

\item{rho.sigma.b.blockDiagonal}{\code{\link{PsiFunction}} to be used for
\code{rho.sigma.b} for models with block-diagonal random effects
covariance matrix.}

\item{...}{passed on to \code{\link{chgDefaults}}.}
}
\description{
Convenience function to create rho-functions with custom tuning parameter.
}
\details{
'rho.b.diagonal' denotes the tuning parameter to be used for 'rho.b' for
models with diagonal random effects covariance matrix. 'rho.b.blockDiagonal'
is the tuning parameter to be used in the block diagonal case, respectively.

For arguments \code{rho.sigma.e} (and \code{rho.sigma.b.diagonal}), the
Proposal 2 variant of the function specified for \code{rho.e} (and
\code{rho.b}) is used.
}
\examples{
  createRhoFunction(c(1.345, 2.28, 1.345, 2.28, 5.14, 5.14), "rho.sigma.e")
}
\author{
Manuel Koller
}
