% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/syncing_df_compress.R,
%   R/syncing_vector_compress.R
\name{syncing_df_compress}
\alias{syncing_df_compress}
\alias{syncing_vector_compress}
\title{Compress a vector or data frame}
\usage{
syncing_df_compress(
  x,
  newLength,
  sep = " ",
  compressFun = NULL,
  compressFunPart = NULL,
  silent = rock::opts$get("silent")
)

syncing_vector_compress(
  x,
  newLength,
  sep = " ",
  compressFun = NULL,
  compressFunPart = NULL,
  silent = rock::opts$get("silent")
)
}
\arguments{
\item{x}{The vector or data frame}

\item{newLength}{The new length (or number of rows for a data frame)}

\item{sep}{When not specifying \code{compressFun} and \code{compressFunPart}, the
\code{paste} function is used to combine elements, and in that case, \code{sep} is
passed to \code{paste} as separator.}

\item{compressFun}{If specified, when compressing streams, instead of pasting
elements together using separator \code{sep}, the vectors are passed to function
\code{compressFun}, which must accept a vector (to compress) and a single integer
(with the desired resulting length of the vector).}

\item{compressFunPart}{A function to apply to the segments that are
automatically created; this can be passed instead of \code{compressFun}.}

\item{silent}{Whether to be silent or chatty.}
}
\value{
The compressed vector or data frame
}
\description{
Compress a vector or data frame
}
\examples{
rock::syncing_vector_compress(
  1:10,
  3
);

rock::syncing_df_compress(
  mtcars[, 1:4],
  6
);

rock::syncing_df_compress(
  mtcars[, 1:4],
  6,
  compressFunPart = mean
);
}
