% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/class.r
\docType{class}
\name{rodeo-class}
\alias{rodeo}
\alias{rodeo-class}
\title{\code{rodeo} Reference Class}
\description{
This documents the \code{rodeo} reference class to represent an ODE-based
model. See the \code{\link{rodeo-package}} main page or type
\code{help(package="rodeo")} for an introduction to the package of
the same name.
}
\section{Fields}{

\describe{
\item{\code{.pros}}{A data frame with fields 'name', 'unit', 'description', and
'expression' defining the process rates.}

\item{\code{.stoi}}{A data frame with fields 'variable', 'process', and 'expression'
reprenting the stoichiometry matrix in data base format.}

\item{\code{.vars}}{A data frame with fields 'name', 'unit', 'description' declaring
the state variables of the model. The declared names become valid
identifiers to be used in the expression fields of \code{.pros} or \code{.stoi}.}

\item{\code{.pars}}{A data frame of the same structure as \code{vars} declaring the
parameters of the model. The declared names become valid
identifiers to be used in the expression fields of \code{.pros} or \code{.stoi}.}

\item{\code{.funs}}{A data frame of the same structure as \code{vars} declaring any
  functions referenced in the expression fields of \code{.pros} or \code{.stoi}.}
}}
\section{Methods}{

\describe{
\item{\code{arrangePars(x, sep = ".", warnUnused = TRUE)}}{Assign values to parameters. See \code{\link{arrangePars}} for details.}

\item{\code{arrangeVars(x, sep = ".", warnUnused = TRUE)}}{Assign values to state variables. See \code{\link{arrangeVars}} for details.}

\item{\code{compile(fileFun, NLVL = 1)}}{Compile Fortran library for use with numerical methods from packages
 \code{\link[deSolve]{deSolve}} or \code{\link[rootSolve]{rootSolve}}.
See \code{\link{compile}} for details.}

\item{\code{generate(lang, name = "derivs")}}{Translate the ODE-model specification into a function that computes process
rates and the state variables derivatives (either in R or Fortran). See
\code{\link{generate}} for details.}

\item{\code{getFuns()}}{Returns the declaration of functions appearing in the ODE's righthand sides
(as a data frame).}

\item{\code{getPars()}}{Returns the declaration of the model's parameters (as a data frame).}

\item{\code{getPros()}}{Returns the declaration of simulated processes (as a data frame).}

\item{\code{getStoi()}}{Returns the model's stoichiometric factors (as a data frame).}

\item{\code{getVars()}}{Returns the declaration of the model's state variables (as a data frame).}

\item{\code{initialize(vars, pars, funs, pros, stoi, asMatrix = FALSE)}}{Initializes a \code{\link{rodeo-class}} object. See
\code{\link{initialize}} for details.}

\item{\code{lenFuns()}}{Returns the number of functions appearing in the ODE's righthand sides
(integer).}

\item{\code{lenPars()}}{Returns the number of parameters appearing in the ODE system (integer).}

\item{\code{lenPros()}}{Returns the number of simulated processes (integer).}

\item{\code{lenVars()}}{Returns the number of state variables appearing in the ODE system (integer).}

\item{\code{namesFuns()}}{Returns the names of functions appearing in the ODE's righthand sides
(vector of mode character).}

\item{\code{namesPars()}}{Returns the names of the model's parameters (vector of mode character).}

\item{\code{namesPros()}}{Returns the names of simulated processes (vector of mode character).}

\item{\code{namesVars()}}{Returns the names of the model's state variables (vector of mode character).}

\item{\code{plotStoichiometry(values, cex = 1, colPositive = "darkorange",
  colNegative = "steelblue4", colGrid = "grey")}}{Plots qualitative stoichiometry information. See
\code{\link{plotStoichiometry}} for details.}

\item{\code{stoichiometry(values = NULL)}}{Returns the stoichiometry matrix, either evaluated (numeric) or not (text).
See \code{\link{stoichiometry}} for details.}
}}
\examples{
data(exampleIdentifiers, exampleProcesses, exampleStoichiometry)
model= new("rodeo",
  vars=subset(exampleIdentifiers, type=="v"),
  pars=subset(exampleIdentifiers, type=="p"),
  funs=subset(exampleIdentifiers, type=="f"),
  pros=exampleProcesses, stoi=exampleStoichiometry
)
model$show()
}
\seealso{
See the \code{\link{rodeo-package}} main page or type
  \code{help(package="rodeo")} to find the documentation of any non-class
  methods contained in the \code{rodeo} package.
}

