% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classMethod_initStepper.r
\name{initStepper}
\alias{initStepper}
\title{Initialize Internal ODE Solver}
\arguments{
\item{sources}{Name(s) of fortran source file(s) where a module with the
fixed name 'functions' is implemented. This module must contain all
user-defined functions referenced in process rates or
stoichiometric factors. Can be \code{NULL}, the name of a single file, or
a vector of file names if the Fortran code is split over several files.}

\item{method}{Name of a the solver. Currently, 'rk5' is the only supported
value (Runge-Kutta method of Cash and Karp).}
}
\value{
\code{invisible(NULL)}
}
\description{
Initializes \code{rodeo}'s built-in ODE solver. This method must be called
prior to using \code{\link{step}}.
}
\note{
After this method was called, \code{\link{step}} can be used to
  perform the integration.
}
\author{
\email{david.kneis@tu-dresden.de}
}
\seealso{
To perform integration with the solvers from package
  \code{\link[deSolve]{deSolve}} use \code{\link{compile}} instead of this
  method.
}

