% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rodham.R
\docType{package}
\name{rodham}
\alias{rodham}
\alias{rodham-package}
\title{rodham: Hillary Rodham Clinton emails}
\description{
rodham: Hillary Rodham Clinton emails
}
\section{Dataset}{

\itemize{
\item{emails}{dataset of 29444 emails}
}
}

\section{Functions}{

\itemize{
\item \code{\link{search_emails}}
\item \code{\link{edges_emails}}
\item \code{\link{get_emails}}
\item \code{\link{get_xpdf}}
}
}
\examples{
\dontrun{
# get emails from internal data set
data("emails")

# build graph
edges <- edges_emails(emails)
g <- igraph::graph.data.frame(edges)
plot(g)

# plot communities
cm <- igraph::walktrap.community(g)
plot(cm, g)

# get extractor to extract content from emails
ext <- get_xpdf()

dir.create("./emails")

# get emails released in august
aug_emails <- get_emails(release = "August", save.dir = "./emails",
                         extractor = ext)

# load txt files
files <- list.files(aug_emails)
content <- lapply(1:length(files), function(x){
   readLines(paste0(aug_emails, "/", files[[x]]))
})
}

}
\keyword{internal}

