% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rofanova-package.R
\docType{package}
\name{rofanova-package}
\alias{rofanova-package}
\alias{_PACKAGE}
\title{Robust Functional Analysis of Variance}
\description{
Implements the robust functional analysis of variance (RoFANOVA), described in Centofanti et al. (2021) <arXiv:2112.10643>. 
    It allows testing mean differences among groups of  functional data by being robust against the presence of outliers.
}
\details{
\tabular{ll}{
Package: \tab rofanova\cr
Type: \tab Package\cr
Version: \tab 1.0.0 \cr
Date: \tab  2022-01-21 \cr
License: \tab GPL-3\cr
}
}
\examples{
library(rofanova)
data_out<-simulate_data(scenario="one-way")
label_1=data_out$label_1
X_fdata<-data_out$X_fdata
B=10
cores=1
per_list_median<-rofanova(X_fdata,label_1,B = B,family="median",cores=cores)
pvalue_median_vec<-per_list_median$pval_vec
per_list_huber<-rofanova(X_fdata,label_1,B = B,family="huber",cores=cores)
pvalue_huber_vec<-per_list_huber$pval_vec
per_list_bisquare<-rofanova(X_fdata,label_1,B = B,family="bisquare",cores=cores)
pvalue_bisquare_vec<-per_list_bisquare$pval_vec
per_list_hampel<-rofanova(X_fdata,label_1,B = B,family="hampel",cores=cores)
pvalue_hampel_vec<-per_list_hampel$pval_vec
per_list_optimal<-rofanova(X_fdata,label_1,B = B,family="optimal",cores=cores)
pvalue_optimal<-per_list_optimal$pval
}
\references{
Centofanti, F., Colosimo, B.M., Grasso, M.L., Menafoglio, A., Palumbo, B., Vantini, S. (2021).
Robust Functional ANOVA with Application to Additive Manufacturing.
\emph{arXiv preprint arXiv:2112.10643}.
}
\seealso{
\code{\link{rofanova}} \code{\link{fusem}} \code{\link{funmad}}
}
\author{
Fabio Centofanti, Bianca Maria Colosimo, Marco Luigi Grasso,
Antonio Lepore, Alessandra Menafoglio, Biagio Palumbo, Simone Vantini
}
