% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flat_table_transform.R
\name{separate_measures}
\alias{separate_measures}
\alias{separate_measures.flat_table}
\title{Separate measures in flat tables}
\usage{
separate_measures(ft, measures, names, na_rm)

\method{separate_measures}{flat_table}(ft, measures = NULL, names = NULL, na_rm = TRUE)
}
\arguments{
\item{ft}{A \code{flat_table} object.}

\item{measures}{A list of string vectors, groups of measure names.}

\item{names}{A list of string, measure group names.}

\item{na_rm}{A boolean, remove rows from output where all measure values are NA.}
}
\value{
A list of \code{flat_table} objects.
}
\description{
Separate measures listed as list items into flat tables. Each item in the
list is a vector of measures that is uniquely included along with the
attributes in a new flat table.
}
\details{
A list of flat tables is returned. It assign the names to the result list.
}
\examples{

lft <- flat_table('iris', iris) |>
  separate_measures(
    measures = list(
      c('Petal.Length'),
      c('Petal.Width'),
      c('Sepal.Length'),
      c('Sepal.Width')
    ),
    names = c('PL', 'PW', 'SL', 'SW')
  )

}
\seealso{
\code{\link{flat_table}}

Other flat table transformation functions: 
\code{\link{add_custom_column}()},
\code{\link{remove_instances_without_measures}()},
\code{\link{replace_empty_values}()},
\code{\link{replace_string}()},
\code{\link{replace_unknown_values}()},
\code{\link{select_attributes}()},
\code{\link{select_instances_by_comparison}()},
\code{\link{select_instances}()},
\code{\link{select_measures}()},
\code{\link{transform_attribute_format}()},
\code{\link{transform_from_values}()},
\code{\link{transform_to_attribute}()},
\code{\link{transform_to_measure}()},
\code{\link{transform_to_values}()}
}
\concept{flat table transformation functions}
