% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flat_table.R, R/generic.R, R/star_database.R
\name{set_attribute_names.flat_table}
\alias{set_attribute_names.flat_table}
\alias{set_attribute_names}
\alias{set_attribute_names.star_database}
\title{Rename attributes}
\usage{
\method{set_attribute_names}{flat_table}(db, name = NULL, old = NULL, new)

set_attribute_names(db, name, old, new)

\method{set_attribute_names}{star_database}(db, name, old = NULL, new)
}
\arguments{
\item{db}{A \code{flat_table} or \code{star_database} object.}

\item{name}{A string, dimension name.}

\item{old}{A vector of names.}

\item{new}{A vector of names.}
}
\value{
A \code{flat_table} or \code{star_database} object.
}
\description{
Rename attributes in a flat table or a dimension in a star database.
}
\examples{

db <- star_database(mrs_cause_schema, ft_num) |>
  set_attribute_names(
    name = "where",
    new = c(
      "Region",
      "State",
      "City"
    )
  )

db <- star_database(mrs_cause_schema, ft_num) |>
  set_attribute_names(name = "where",
                      old = c("REGION"),
                      new = c("Region"))

ft <- flat_table('iris', iris) |>
  set_attribute_names(
    old = c('Species'),
    new = c('species'))

}
\seealso{
\code{\link{star_database}}, \code{\link{flat_table}}

Other star database and flat table functions: 
\code{\link{get_attribute_names.flat_table}()},
\code{\link{get_measure_names.flat_table}()},
\code{\link{get_similar_attribute_values.flat_table}()},
\code{\link{get_similar_attribute_values_individually.flat_table}()},
\code{\link{get_unique_attribute_values.flat_table}()},
\code{\link{replace_attribute_values.flat_table}()},
\code{\link{set_measure_names.flat_table}()},
\code{\link{snake_case.flat_table}()}
}
\concept{star database and flat table functions}
