% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roll.R
\name{roll_sd}
\alias{roll_sd}
\title{Rolling Standard Deviations}
\usage{
roll_sd(data, width, weights = rep(1, width), center = TRUE,
  min_obs = width, complete_obs = FALSE, na_restore = FALSE,
  parallel_for = c("rows", "cols"))
}
\arguments{
\item{data}{matrix or xts object. Rows are observations and columns are variables.}

\item{width}{integer. Window size.}

\item{weights}{vector. Weights for each observation within a window.}

\item{center}{logical. If \code{TRUE} then the weighted mean of each variable is used,
if \code{FALSE} then zero is used.}

\item{min_obs}{integer. Minimum number of observations required to have a value within a window,
otherwise result is NA.}

\item{complete_obs}{logical. If \code{TRUE} then rows containing any missing values are removed,
if \code{FALSE} then each value is used.}

\item{na_restore}{logical. Should missing values be restored?}

\item{parallel_for}{character. Executes a "for" loop in which iterations run in parallel by
\code{rows} or \code{cols}.}
}
\value{
An object of the same class and dimension as \code{data} with the rolling standard deviations.
}
\description{
A parallel function for computing rolling standard deviations of time-series data.
}
\examples{
n_vars <- 10
n_obs <- 1000
data <- matrix(rnorm(n_obs * n_vars), nrow = n_obs, ncol = n_vars)

# 252-day rolling standard deviation
result <- roll_sd(data, 252)

# Equivalent to 'na.rm = TRUE'
result <- roll_sd(data, 252, min_obs = 1)

# Expanding window
result <- roll_sd(data, n_obs, min_obs = 1)

# Exponential decay
weights <- 0.9 ^ (251:0)
result <- roll_sd(data, 252, weights, min_obs = 1)
}
\seealso{
\code{\link[RcppParallel]{setThreadOptions}} for thread options via RcppParallel.
}

