% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_classes.R
\name{triple_to_tidy}
\alias{triple_to_tidy}
\title{Triple Omic to Tidy Omic}
\usage{
triple_to_tidy(triple_omic)
}
\arguments{
\item{triple_omic}{an object of class triple_omic produced by
\code{\link{create_triple_omic}}}
}
\value{
A \code{tidy_omic} object as created by
  \code{\link{create_tidy_omic}}.
}
\description{
Convert a \code{triple_omic} object into a \code{tidy_omic} oobject.
}
\details{
Features, samples and measurements will be merged into a single \code{data}
  table, and the \code{design} will be preserved as-is.
}
\examples{

library(dplyr)

measurement_df <- tidyr::expand_grid(
  feature_id = 1:10,
  sample_id = LETTERS[1:5]
) \%>\%
  dplyr::mutate(value = rnorm(n()))

feature_df <- tibble(
  feature_id = 1:10,
  feature_group = rep(c("a", "b"), each = 5)
)
sample_df <- tibble(
  sample_id = LETTERS[1:5],
  sample_group = c("a", "a", "b", "b", "b")
)

triple_omic <- create_triple_omic(
  measurement_df, feature_df, sample_df,
  "feature_id", "sample_id"
)
triple_to_tidy(triple_omic)
}
