% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auth.R
\name{orcid_auth}
\alias{orcid_auth}
\alias{rorcid-auth}
\title{ORCID authorization}
\usage{
orcid_auth(scope = "/authenticate", reauth = FALSE,
  redirect_uri = getOption("rorcid.redirect_uri"))
}
\arguments{
\item{scope}{(character) one or more scopes. default: \code{"/authenticate"}}

\item{reauth}{(logical) Force re-authorization?}

\item{redirect_uri}{(character) a redirect URI. optional}
}
\value{
a character string with the access token prefixed with "Bearer "
}
\description{
ORCID authorization
}
\details{
There are two ways to authorise with \pkg{rorcid}:
\itemize{
\item Use a token as a result of a OAuth authentication process. The token
is a alphanumeric UUID, e.g. \code{dc0a6b6b-b4d4-4276-bc89-78c1e9ede56e}. You
can get this token by running \code{orcid_auth()}, then storing that key
(the uuid alone, not the "Bearer " part) either as en environment
variable in your \code{.Renviron} file in your home directory (with the name
\code{ORCID_TOKEN}), or as an R option in your \code{.Rprofile} file (with the name
\code{orcid_token}). See \link{Startup} for more information.
Either an environment variable or R option work. If we don't find
either we do the next option.
\item Interactively login with OAuth. This doesn't require any input on
your part. We use a client id and client secret key to ping ORCID.org;
at which point you log in with your username/password; then we get back
a token (same as the above option). We don't know your username or
password, only the token that we get back. We cache that token locally
in a hidden file in whatever working directory you're in. If you delete
that file, or run the code from a new working directory, then we
re-authorize.
}

We recommend the former option. That is, get a token and store it as an
environment variable.

If both options above fail, we proceed without using authentication.
ORCID does not require authentication at this point, but may in the future -
this prepares you for when that happens :)
}
\section{ORCID OAuth Scopes}{

See \url{https://members.orcid.org/api/orcid-scopes} for more
}

\section{Computing environments without browsers}{

One pitfall is when you are using rorcid on a server, and you're ssh'ed
in, so that there's no way to open a browser to do the OAuth browser
flow. Similarly for any other situation in which a browser can not be
opened. In this case, run \code{orcid_auth()} on another machine in which you do
have the ability to open a browser, then collect the info that's ouptput
from \code{orcid_auth()} and store it as an environment variable (see above).
}

\examples{
\dontrun{
x <- orcid_auth()
orcid_auth(reauth = TRUE)
#orcid_auth(scope = "/read-public", reauth = TRUE)
}
}
