% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osmraster.R
\name{osm.image}
\alias{osm.image}
\alias{osm.raster}
\title{Get Open Street Map Tiles As A RasterStack}
\usage{
osm.image(
  x,
  zoomin = 0,
  zoom = NULL,
  type = NULL,
  forcedownload = FALSE,
  cachedir = NULL,
  progress = c("text", "none"),
  quiet = TRUE
)

osm.raster(
  x,
  zoomin = 0,
  zoom = NULL,
  type = "osm",
  forcedownload = FALSE,
  cachedir = NULL,
  progress = c("text", "none"),
  quiet = TRUE,
  projection = NULL,
  crop = FALSE,
  filename = NULL,
  resample = "bilinear",
  ...
)
}
\arguments{
\item{x}{A bounding box as generated by \code{sp::bbox()} or
\code{prettymapr::searchbbox()}. Must be in lon/lat (epsg:4326)!
Alternatively, pass a \code{Spatial*} object to use the bounding box of
that}

\item{zoomin}{The amount by which to adjust the automatically calculated zoom
(or manually specified if the \code{zoom} parameter is passed). Use +1 to
zoom in, or -1 to zoom out.}

\item{zoom}{Manually specify the zoom level (not recommended; adjust
\code{zoomin} instead.}

\item{type}{A map type; one of that returned by \link{osm.types}. User
defined types are possible by defining \code{tile.url.TYPENAME <-
function(xtile, ytile, zoom){}} and passing TYPENAME as the \code{type}
argument.}

\item{forcedownload}{\code{TRUE} if cached tiles should be re-downloaded.
Useful if some tiles are corrupted.}

\item{cachedir}{The directory in which tiles should be cached. Defaults to
\code{getwd()/rosm.cache}.}

\item{progress}{A progress bar to use, or "none" to suppress progress updates}

\item{quiet}{Pass \code{FALSE} to see more error messages, particularly if
your tiles do not download/load properly.}

\item{projection}{A map projection in which to reproject the RasterStack as
generated by \code{CRS()} or \code{Spatial*@proj4string}. If a
\code{Spatial*} object is passed as the first argument, this argument will
be ignored.}

\item{crop}{\code{TRUE} if results should be cropped to the specified
bounding box (see \code{x}), \code{FALSE} otherwise.}

\item{filename}{A filename to which the raster should be written (see
\code{raster::writeRaster()}). Use a ".tif" extension to write as a
GeoTIFF.}

\item{resample}{One of "ngb" (nearest neighbour) or "bilinear". Passed to
\link[raster]{projectRaster}.}

\item{...}{Arguments passed on to \code{raster::writeRaster()} if
\code{filename} is specified.}
}
\value{
A projected RasterStack of the fused tiles.
}
\description{
Get Open Street Map tiles as RasterStack object (requires package
\code{raster} to be installed).
}
\examples{
\dontshow{if (identical(Sys.getenv("R_PRETTYMAPR_HAS_API_KEY"), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
library(cartography)
library(raster)
library(prettymapr)

ns <- makebbox(47.2, -59.7, 43.3, -66.4)
x <- osm.raster(ns, projection=CRS("+init=epsg:26920"), crop=TRUE)
# plot using plotRGB (from the raster package)
plotRGB(x)

# use a Spatial* object as the first argument to automatically set the bounding
# box and projection
data(nuts2006)
spdf <- nuts0.spdf[nuts0.spdf$id=="DE",]
x <- osm.raster(spdf, type="thunderforestlandscape")
plotRGB(x)

# write to disk by passing a filename argument (use .tif extension to write GeoTIFF)
osm.raster(ns, projection=CRS("+init=epsg:26920"), crop=TRUE, filename="ns.tif")

# can also write Raster* objects using osm.raster
tf <- tempfile(fileext = ".tif")
osm.raster(x, filename=tf)
unlink(tf)

}
\dontshow{\}) # examplesIf}
}
