\name{discord}
\alias{discord}
\title{Measure of Discord}
\usage{
  discord(x, type, t = 1L, obs = 1:nrow(x))
}
\arguments{
  \item{x}{The sample of random rotations}

  \item{type}{To specify if "intrinsic" or "extrinsic"
  approach should be used to compute the statistic}

  \item{t}{If test blocs then the bloc size, set to 1 by
  default}

  \item{obs}{integer vector specifying which observation(s)
  to compute the measure of discord for}
}
\value{
  The Hi statistic for each group of size t is returned.
  If \code{t>1} then which observations that define each
  group of size \code{t} is returned as well.
}
\description{
  This function computes a measure of discord for a sample
  of random rotations. The larger the statistic value the
  less likely it is the corresponding observation was
  generated by the same mechanism the rest of the data as
  generated by. It can be used to test for outliers in
  SO(3) by comparing it to an F distribution with 3,3(n-2)
  df for the Cayley or matrix Fisher distributions or to an
  F distribution with 1,n-2 df for the von Mises Fisher
  distribution.
}
\examples{
#Compute the measures of discord for a sample from the Cayley distribution
Rs <- ruars(20,rcayley,kappa=1)
Hi <- discord(Rs, type='intrinsic')
He <- discord(Rs, type='extrinsic')

#Compare to the theoretical F distribution
OrdHi <- sort(Hi)
OrdHe <- sort(He)

par(mfrow=c(1,2))
plot(ecdf(OrdHi),main='Intrinsic',xlim=range(c(OrdHi,OrdHe)))
lines(OrdHi,pf(OrdHi,3,3*(length(OrdHi)-2)))

plot(ecdf(OrdHe),main='Extrinsic',xlim=range(c(OrdHi,OrdHe)))
lines(OrdHi,pf(OrdHi,3,3*(length(OrdHe)-2)))
}

