% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/studies-methods.R, R/studies.R
\name{get_tree_ids}
\alias{candidate_for_synth}
\alias{candidate_for_synth.study_meta}
\alias{get_publication}
\alias{get_publication.study_meta}
\alias{get_study_meta}
\alias{get_study_year}
\alias{get_study_year.study_meta}
\alias{get_tree_ids}
\alias{get_tree_ids.study_meta}
\title{Study Metadata}
\usage{
get_tree_ids(sm)

get_publication(sm)

candidate_for_synth(sm)

get_study_year(sm)

\method{get_tree_ids}{study_meta}(sm)

\method{get_publication}{study_meta}(sm)

\method{candidate_for_synth}{study_meta}(sm)

\method{get_study_year}{study_meta}(sm)

get_study_meta(study_id, ...)
}
\arguments{
\item{sm}{an object created by \code{get_study_meta}}

\item{study_id}{the study identifier (character)}

\item{...}{additional arguments to customize the API request (see
\code{\link{rotl}} package documentation).}
}
\value{
named-list containing the metadata associated with the
    study requested
}
\description{
Retrieve metadata about a study in the Open Tree of Life datastore.
}
\details{
\code{get_study_meta} returns a long list of attributes for the
studies that are contributing to the synthetic tree. To help with
the extraction of relevant information from this list, several
helper functions exists: \itemize{

\item {get_tree_ids} { The identifiers of the trees
  associated with the study }

\item {get_publication} { The citation information of the
  publication for the study. The DOI (or URL) for the study is
  available as an attribute to the returned object (i.e.,
  \code{attr(object, "DOI")} ) }.

\item {candidate_for_synth} { The identifier of the tree(s) from
  the study used in the synthetic tree. This is a subset of the
  result of \code{get_tree_ids}.

\item {get_study_year} { The year of publication of the study. }

}
}
}
\examples{
\dontrun{
req <- get_study_meta("pg_719")
get_tree_ids(req)
candidate_for_synth(req)
get_publication(req)
get_study_year(req)
}
}

