% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnose.R
\name{ChenThissen1997}
\alias{ChenThissen1997}
\alias{chen.thissen.1997}
\title{Computes local dependence indices for all pairs of items}
\usage{
ChenThissen1997(grp, ..., data = NULL, inames = NULL, qwidth = 6,
  qpoints = 49, method = "pearson", .twotier = TRUE, .parallel = TRUE)
}
\arguments{
\item{grp}{a list with the spec, param, mean, and cov describing the group}

\item{...}{Not used.  Forces remaining arguments to be specified by name.}

\item{data}{data}

\item{inames}{a subset of items to examine}

\item{qwidth}{quadrature width}

\item{qpoints}{number of equally spaced quadrature points}

\item{method}{method to use to calculate P values. The default is the
Pearson X^2 statistic. Use "lr" for the similar likelihood ratio statistic.}

\item{.twotier}{whether to enable the two-tier optimization}

\item{.parallel}{whether to take advantage of multiple CPUs (default TRUE)}
}
\value{
a list with raw, pval and detail. The pval matrix is a
lower triangular matrix of log P values with the sign
determined by relative association between the observed and
expected tables (see \code{\link{ordinal.gamma}})
}
\description{
Item Factor Analysis makes two assumptions: (1) that the latent
distribution is reasonably approximated by the multivariate Normal
and (2) that items are conditionally independent. This test
examines the second assumption. The presence of locally dependent
items can inflate the precision of estimates causing a test to
seem more accurate than it really is.
}
\details{
Statically significant entries suggest that the item pair has
local dependence. Since log(.01)=-4.6, an absolute magitude of 5
is a reasonable cut-off. Positive entries indicate that the two
item residuals are more correlated than expected. These items may share an
unaccounted for latent dimension. Consider a redesign of the items
or the use of testlets for scoring. Negative entries indicate that
the two item residuals are less correlated than expected.
}
\references{
Chen, W.-H. & Thissen, D. (1997). Local dependence
indexes for item pairs using Item Response Theory. \emph{Journal
of Educational and Behavioral Statistics, 22}(3), 265-289.

Thissen, D., Steinberg, L., & Mooney, J. A. (1989). Trace lines for testlets: A use
of multiple-categorical-response models. \emph{Journal of Educational Measurement,
26} (3), 247--260.

Wainer, H. & Kiely, G. L. (1987). Item clusters and computerized
adaptive testing: A case for testlets.  \emph{Journal of
Educational measurement, 24}(3), 185--201.
}
\seealso{
\href{https://github.com/jpritikin/ifaTools}{ifaTools}
}
