% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resolve_phylopic.R
\name{resolve_phylopic}
\alias{resolve_phylopic}
\title{Use a taxonomic name from another database to get a PhyloPic image UUID}
\usage{
resolve_phylopic(
  name,
  api = "gbif.org",
  hierarchy = FALSE,
  max_ranks = 5,
  n = 1,
  filter = NULL,
  url = FALSE
)
}
\arguments{
\item{name}{\code{character}. A full or partial taxonomic name to be queried
via the specified \code{api}.}

\item{api}{\code{character}. The API in which to query \code{name}. See Details
for the available options.}

\item{hierarchy}{\code{logical}. Whether the taxonomic hierarchy of \code{name}
should be retrieved from the API and used to get several sets of PhyloPic
image uuids (or urls).}

\item{max_ranks}{\code{numeric}. The maximum number of taxonomic ranks that
should be included if \code{hierarchy} is \code{TRUE}.}

\item{n}{\code{numeric}. How many uuids should be returned? Depending on
the requested \code{name}, multiple silhouettes might exist. If \code{n} exceeds
the number of available images, all available uuids will be returned.
This argument defaults to 1.}

\item{filter}{\code{character}. Filter uuid(s) by usage license. Use "by" to
limit results to image uuids which do not require attribution, "nc" for
image uuids which allow commercial usage, and "sa" for image uuids without
a ShareAlike clause. The user can also combine these filters as a vector.}

\item{url}{\code{logical}. If \code{FALSE} (default), only the uuid is
returned. If \code{TRUE}, a valid PhyloPic image url of the uuid is
returned.}
}
\value{
A \code{list} where each value is \code{n} (or fewer) PhyloPic image uuids (or
urls if \code{url = TRUE}) and each name is the taxonomic name as matched and
reported by the specified \code{api}. If \code{hierarchy} is \code{FALSE}, the list has
length 1. If \code{hierarchy} is \code{TRUE}, the list has maximum length
\code{max_ranks}.
}
\description{
This function takes a supplied taxonomic name, queries it via the specified
external API, resolves the API's returned taxonomic ID to the PhyloPic
taxonomic node database, then retrieves PhyloPic image uuids (or urls) for
that node.
}
\details{
If \code{hierarchy} is \code{FALSE}, the specified \code{name} is queried via the
specified \code{api}. The matched id is then resolved to the matching taxonomic
node in the PhyloPic database. If \code{hierarchy} is \code{TRUE}, the full taxonomic
hierarchy for \code{name} is retrieved from the specified \code{api}, those taxonomic
names are subset to \code{max_ranks} ranks (starting from the specified \code{name}
and ascending the hierarchy). Then each of those names is resolved to the
matching taxonomic node in the PhyloPic database (where possible). In
either case, \code{\link[=get_uuid]{get_uuid()}} is then used to retrieve \code{n} image UUID(s) for
each taxonomic name.

Note that while the names of the returned list are the taxonomic names as
reported by the specified \code{api}, the PhyloPic images that are returned are
associated with whatever taxonomic node that taxonomic name resolves to in
the PhyloPic database. This means that, if \code{hierarchy} is \code{TRUE}, the same
images may be returned for multiple taxonomic names. Also, if a particular
taxonomic name does not resolve to any node in the PhyloPic database, no
images will be returned for that name.

The following APIs are available for querying (\code{api}):
\itemize{
\item{"eol.org": the \href{https://eol.org/}{Encyclopedia of Life}}
(note: \code{hierarchy = TRUE} is not currently available for this API) ("eol"
is also allowed)
\item{"gbif.org": the \href{https://www.gbif.org/}{Global Biodiversity
Information Facility}} ("gbif" is also allowed)
\item{"marinespecies.org": the \href{https://marinespecies.org/}{World
Registor of Marine Species}} ("worms" is also allowed)
\item{"opentreeoflife.org": the \href{https://tree.opentreeoflife.org/}{
Open Tree of Life}} ("otol" is also allowed)
\item{"paleobiodb.org": the \href{https://paleobiodb.org/#/}{Paleobiology
Database}} ("pbdb" is also allowed)
}
}
\examples{
\dontrun{
# get a uuid for a single name
resolve_phylopic(name = "Canis lupus")
# get uuids for the taxonomic hierarchy
resolve_phylopic(name = "Velociraptor mongoliensis", api = "paleobiodb.org",
                 hierarchy = TRUE, max_ranks = 3)
}
}
