% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pgTrajSchema.R
\name{pgtrajSchema}
\alias{pgtrajSchema}
\title{Check/create pgtraj schema.}
\usage{
pgtrajSchema(conn, schema = "traj")
}
\arguments{
\item{conn}{Connection object created with RPostgreSQL.}

\item{schema}{Character string. Name of the schema that stores or
will store the pgtraj data model.}
}
\value{
\code{TRUE} if the schema exists (whether it was already
    available or was successfully created).
}
\description{
Checks if the provided schema is a valid pgtraj schema, and
creates one if it does not exist.
}
\details{
Creates a schema to store \code{pgtraj}s in the database by
calling a SQL script from \code{./sql/traj_schema.sql}. The schema
name defaults to \code{traj}. If a schema with the provided name
already exists in the database, it checks if it contains all the
required tables. The function does not attempt to repair the
schema if all pgtraj tables are not present (e.g. because some
were manually deleted).  In this case, a new pgtraj schema needs
to be created, or the existing schema needs to be deleted and
recreated.

The function has its own standalone transaction control.
}
\examples{
\dontrun{
  # Check (or create) pgtraj schema with name "traj_1"
  pgtrajSchema(conn,"traj_1")
}
}
\author{
Balázs Dukai \email{balazs.dukai@gmail.com}
}
