% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/incidence.R
\name{plot.incidence}
\alias{plot.incidence}
\title{Visualise disease incidence.}
\usage{
\method{plot}{incidence}(x, level = 0.95, ...)
}
\arguments{
\item{x}{An \code{incidence} object.}

\item{level}{The desired confidence interval width.}

\item{...}{Arguments passed to \code{plot}.}
}
\value{
An object of class \code{ggplot}.
}
\description{
Plots a comparison between the smoothed daily incidence function and actual
incidence.
}
\details{
This function generates a plot from the cumulative incidence object. The
incidence rate per year of the registry is shown in red. Mean incidence rate
is shown as a solid blue line, with the confidence interval shown in dashed
blue lines. The smooth fitted to the cumulative incidence data is shown in
green.
}
\examples{
data(prevsim)

\dontrun{
inc <- incidence(prevsim$entrydate, population_size=1e6, start = "2004-01-30", num_reg_years = 9)

plot(inc)
}

}
\seealso{
Other incidence functions: \code{\link{incidence_age_distribution}},
  \code{\link{incidence}},
  \code{\link{mean_incidence_rate}},
  \code{\link{raw_incidence}},
  \code{\link{test_incidence_fit}},
  \code{\link{yearly_incidence}}
}
