% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{immdef}
\alias{immdef}
\title{immdef}
\format{A simulated data frame with 9 variables and 1000 observations representing a study where participants 
were randomly assigned to receive treatment immediately or deferred. Participants in the deferred 
arm could crossover and receive treatment. The primary endpoint was time to disease progression.

The data are based on a randomized controlled trial Concorde \url{http://dx.doi.org/10.1016/S0140-6736(94)90006-X}
\describe{
   \item{id}{participant ID number}
   \item{def}{indicator that the participant was assigned to the Deferred treatment arm}
   \item{imm}{indicator that the participant was assigned to the Immediate treatment arm}
   \item{censyrs}{a real, or theoretical censoring time (from randomisation), corresponding to the close of study}
   \item{xo}{an indicator that crossover occurred}
   \item{xoyrs}{the time from randomisation at which crossover happened, or 0 for participants in the Immediate arm}
   \item{prog}{an indicator of disease progression (1), or censoring (0)}
   \item{progyrs}{time from randomisation of disease progression or censoring}
   \item{entry}{the time from the global start of study of the participant's entry into the study}
 
  }}
\usage{
immdef
}
\description{
Simulated data to use with the \code{\link{rpsftm}} function.
}
\keyword{datasets}
