% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jupyter.R
\name{jupyter}
\alias{jupyter}
\alias{add_jupyter}
\alias{jupyter_bin}
\alias{jupyter_register_R}
\alias{jupyter_options}
\alias{jupyter_launch}
\alias{jupyter_check_launch}
\alias{jupyter_server_list}
\alias{jupyter_server_stop}
\alias{jupyter_server_stop_all}
\title{Install, register, launch 'Jupyter' notebook to the virtual environment}
\usage{
add_jupyter(..., register_R = TRUE)

jupyter_bin()

jupyter_register_R(
  user = NULL,
  name = "ir",
  displayname = "R",
  rprofile = NULL,
  prefix = NULL,
  sys_prefix = NULL,
  verbose = getOption("verbose")
)

jupyter_options(
  root_dir,
  host = "127.0.0.1",
  port = 8888,
  open_browser = FALSE,
  token = rand_string()
)

jupyter_launch(
  host = "127.0.0.1",
  port = 8888,
  open_browser = TRUE,
  workdir = getwd(),
  async = FALSE,
  ...,
  dry_run = FALSE
)

jupyter_check_launch(
  port = 8888,
  host = "127.0.0.1",
  open_browser = TRUE,
  workdir = getwd(),
  async = "auto",
  ...
)

jupyter_server_list()

jupyter_server_stop(port, ...)

jupyter_server_stop_all(...)
}
\arguments{
\item{...}{for \code{add_jupyter}, these are additional parameters passed to
\code{jupyter_register_R}; for \code{jupyter_launch}, these are additional
parameters passed to \code{jupyter_options}}

\item{register_R}{whether to register \code{IRkernel} to the notebook}

\item{user, name, displayname, rprofile, prefix, sys_prefix, verbose}{see \code{\link[IRkernel]{installspec}}}

\item{root_dir, workdir}{default root directory of the notebook}

\item{host, port}{'IP' and port of the hosting 'URL'}

\item{open_browser}{whether to open the browser once launched}

\item{token}{access token of the notebook}

\item{async}{whether to open the notebook in the background}

\item{dry_run}{whether to display the command instead of executing them;
used to debug the code}
}
\value{
\code{jupyter_bin} returns the 'Jupyter' notebook binary path;
\code{jupyter_options} returns the 'Jupyter' configuration in strings;
\code{jupyter_server_list} returns a table of existing local 'Jupyter'
server hosts, ports, and tokens; \code{jupyter_check_launch} returns true
if a new server has been created, or false if there has been an existing
server at the port;
other functions return nothing.
}
\description{
Install, register, launch 'Jupyter' notebook to the virtual environment
}
\examples{
\dontrun{

# Requires installation of conda
library(rpymat)

# Install conda, if you have done so, skip
configure_conda()


# Install Jupyter notebook
add_jupyter(register_R = TRUE)


# Utility functions
jupyter_bin()

# Please install `dipsaus` package to enable `async=TRUE` with
# better experience
jupyter_launch(async = FALSE, open_browser = TRUE)


}

}
