% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_opal.R
\name{update_course_test}
\alias{update_course_test}
\title{Referenzierte Lernressource eines Kursbausteins austauschen}
\usage{
update_course_test(
  course_id,
  node_id,
  resource_id,
  api_user = NULL,
  api_password = NULL,
  endpoint = NULL
)
}
\arguments{
\item{course_id}{\itemize{
\item Kursnummer. Sie finden diese in den Detailinformationen
des Kurses (Ressourcen-ID).
}}

\item{node_id}{Kursbausteinnummer. Diese befindet sich beispielsweise im
Kurseditor im Tab "Titel und Beschreibung" des betreffenden Kursbausteins.}

\item{resource_id}{ID der Ressource. Sie finden diese u.a. in der
Detailansicht der gewünschten Ressource}

\item{api_user}{A character value of the username in the OPAL.}

\item{api_password}{A character value of the password in the OPAL.}

\item{endpoint}{A string of endpoint of LMS Opal; by default it is got from
environment variable \code{RQTI_API_ENDPOINT}. To set a global environment
variable, you need to call
\code{Sys.setenv(RQTI_API_ENDPOINT='xxxxxxxxxxxxxxx')} or you can put these
command into .Renviron.}
}
\value{
Zu einem Kurs mit der übergebenen Kursnummer (courseId) wird am
Kursbaustein (nodeId) die hinterlegte LernressourceID ausgetauscht. Die, in
der Anfrage enthaltene Ressource (repoID), wird als neuer Inhalt am
Kursbaustein referenziert. Eine solche Aktualisierung ist nur für
Ressourcen vom Typ Test und Fragebogen verfügbar.
}
\description{
Referenzierte Lernressource eines Kursbausteins austauschen
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
   update_course_test("89068111333293", "1617337826161777006", "44829868033")
\dontshow{\}) # examplesIf}
}
