/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.sse.builders;

import com.hp.hpl.jena.sparql.sse.Item;
import com.hp.hpl.jena.sparql.sse.ItemList;
import com.hp.hpl.jena.sparql.sse.ItemLocation;
import com.hp.hpl.jena.sparql.sse.builders.ExprBuildException;

public class BuilderLib {
    public static void checkNode(Item item) {
        if (item.isNode()) {
            return;
        }
        BuilderLib.broken(item, "Not a node: " + item.shortString());
    }

    public static void checkSymbol(Item item) {
        if (item.isSymbol()) {
            return;
        }
        BuilderLib.broken(item, "Not a symbol: " + item.shortString());
    }

    public static void checkTagged(Item item, String tag, String msg) {
        if (item.isTagged(tag)) {
            return;
        }
        BuilderLib.broken((ItemLocation)item, msg, item);
    }

    public static void checkTagged(Item item, int len, String tag, String msg) {
        if (item.isTagged(tag) && item.getList().size() == len) {
            return;
        }
        BuilderLib.broken((ItemLocation)item, msg, item);
    }

    public static void checkTag(ItemList list, String tag) {
        if (list.size() == 0) {
            BuilderLib.broken(list, "Empty list");
        }
        if (!list.get(0).isSymbolIgnoreCase(tag)) {
            BuilderLib.broken(list, "List does not start (" + tag + "...) : " + list.shortString());
        }
    }

    public static void checkList(Item item) {
        if (item.isList()) {
            return;
        }
        BuilderLib.broken(item, "Not a list: " + item.shortString());
    }

    public static void checkList(Item item, String msg) {
        if (item.isList()) {
            return;
        }
        if (msg == null && item.isSymbol()) {
            msg = "Attempt to use a symbol where list expected: " + item.shortString();
        }
        if (msg == null && item.isNode()) {
            msg = "Attempt to use a node where list expected: " + item.shortString();
        }
        if (msg == null) {
            msg = "Not a list";
        }
        BuilderLib.broken(item, msg);
    }

    public static void warning(ItemLocation location, String msg) {
        msg = BuilderLib.msg(location, msg);
        System.err.println(msg);
    }

    public static void checkLength(int len1, int len2, ItemList list, String msg) {
        if (list.size() >= len1 && list.size() <= len2) {
            return;
        }
        msg = msg == null ? "Wrong number of arguments: (" + len1 + "-" + len2 + ")/" + list.size() + " : " + list.shortString() : msg + " : " + list.shortString();
        BuilderLib.broken(list, msg);
    }

    public static void checkLength(int len, ItemList list, String msg) {
        if (list.size() == len) {
            return;
        }
        msg = msg == null ? "Wrong number of arguments: " + len + "/" + list.size() + " : " + list.shortString() : msg + " : " + list.shortString();
        BuilderLib.broken(list, msg);
    }

    public static void checkLengthAtLeast(int len, ItemList list, String msg) {
        if (list.size() >= len) {
            return;
        }
        msg = msg == null ? "Too few arguments: want > " + len + " :got : " + list.size() + " : " + list.shortString() : msg + " : " + list.shortString();
        BuilderLib.broken(list, msg);
    }

    public static void broken(Item item, String msg) {
        BuilderLib.broken((ItemLocation)item, msg, item);
    }

    public static void broken(String msg) {
        System.err.println(msg);
        BuilderLib.exception(msg);
    }

    public static void exception(String msg) {
        throw new ExprBuildException(msg);
    }

    public static void broken(ItemLocation location, String msg, Item item) {
        msg = BuilderLib.msg(location, msg);
        System.err.println(msg + ": " + item.shortString());
        BuilderLib.exception(msg);
    }

    public static void broken(ItemList list, String msg) {
        BuilderLib.broken((ItemLocation)list, msg, list);
    }

    public static void broken(ItemLocation location, String msg, ItemList list) {
        msg = BuilderLib.msg(location, msg);
        System.err.println(msg + ": " + list.shortString());
        BuilderLib.exception(msg);
    }

    public static void broken(ItemLocation location, String msg) {
        msg = BuilderLib.msg(location, msg);
        System.err.println(msg);
        BuilderLib.exception(msg);
    }

    public static String msg(ItemLocation location, String msg) {
        if (location != null) {
            msg = location.location() + ": " + msg;
        }
        return msg;
    }
}

