/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.lang.rdql;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.sparql.lang.rdql.Q_URI;
import com.hp.hpl.jena.sparql.lang.rdql.RDQLParser;

public class Q_QuotedURI
extends Q_URI {
    String seen = "";
    boolean isAbsolute = false;
    static final String prefixOperator = ":";

    Q_QuotedURI(int id) {
        super(id);
    }

    Q_QuotedURI(RDQLParser p, int id) {
        super(p, id);
    }

    void set(String s) {
        this.seen = s;
    }

    public void jjtClose() {
        super._setURI(this.seen);
        super.jjtClose();
    }

    public void postParse2(Query query2) {
        if (!this.isAbsolute) {
            this.absolute(query2);
        }
        super.postParse2(query2);
    }

    private void absolute(Query query2) {
        if (query2 == null) {
            this.isAbsolute = true;
            return;
        }
        int i = this.seen.indexOf(prefixOperator);
        if (i < 0) {
            this.isAbsolute = true;
            return;
        }
        String prefix = this.seen.substring(0, i);
        String full = query2.getPrefix(prefix);
        if (full == null) {
            this.isAbsolute = true;
            super._setNode(Node.createURI((String)this.seen));
            return;
        }
        String remainder = this.seen.substring(i + prefixOperator.length());
        super._setURI(full + remainder);
        super._setNode(Node.createURI((String)super.getURI()));
        this.isAbsolute = true;
    }

    public static Q_URI makeURI(String s) {
        Q_URI uri = new Q_URI(0);
        uri._setURI(s);
        return uri;
    }

    public String asQuotedString() {
        return "<" + this.seen + ">";
    }

    public String asUnquotedString() {
        return this.seen;
    }

    public String valueString() {
        return super.getURI();
    }

    public String toString() {
        return this.seen;
    }
}

