/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot.out;

import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import org.openjena.riot.RiotException;

public class TurtleValidate {
    protected static boolean checkValidPrefixedName(String ns, String local) {
        return TurtleValidate.checkValidPrefixPart(ns) && TurtleValidate.checkValidNamePart(local);
    }

    protected static boolean checkValidPrefixPart(String s) {
        if (s.length() == 0) {
            return true;
        }
        StringCharacterIterator cIter = new StringCharacterIterator(s);
        char ch = cIter.first();
        if (!TurtleValidate.checkNameStartChar(ch)) {
            return false;
        }
        if (ch == '_') {
            return false;
        }
        return TurtleValidate.checkNameTail(cIter);
    }

    private static boolean checkValidPrefixName(String prefixedName) {
        String x;
        int i = prefixedName.indexOf(58);
        if (i < 0) {
            throw new RiotException("Broken short form -- " + prefixedName);
        }
        String p = prefixedName.substring(0, i);
        return TurtleValidate.checkValidPrefixedName(p, x = prefixedName.substring(i + 1));
    }

    protected static boolean checkValidNamePart(String s) {
        if (s.length() == 0) {
            return true;
        }
        StringCharacterIterator cIter = new StringCharacterIterator(s);
        char ch = cIter.first();
        if (!TurtleValidate.checkNameStartChar(ch)) {
            return false;
        }
        return TurtleValidate.checkNameTail(cIter);
    }

    private static boolean checkNameTail(CharacterIterator cIter) {
        char ch = cIter.next();
        while (ch != '\uffff') {
            if (!TurtleValidate.checkNameChar(ch)) {
                return false;
            }
            ch = cIter.next();
        }
        return true;
    }

    protected static boolean checkNameStartChar(char ch) {
        if (Character.isLetter(ch)) {
            return true;
        }
        return ch == '_';
    }

    protected static boolean checkNameChar(char ch) {
        if (Character.isLetterOrDigit(ch)) {
            return true;
        }
        if (ch == '_') {
            return true;
        }
        return ch == '-';
    }
}

