% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rr_journal_issn.R
\name{rr_journal_issn}
\alias{rr_journal_issn}
\title{Retrieve journal policy using ISSN}
\usage{
rr_journal_issn(issn, key = NULL)
}
\arguments{
\item{issn}{[\code{character(1+)}]\cr{}
one or a vector of journal(s) ISSN(s)}

\item{key}{[\code{character(1)}]\cr{}
a character string containing the API key or \code{NULL}
(see Details section on how to specify it)}
}
\value{
Returns a data.frame with complete information from journal:
\itemize{
\item \code{title}        [\code{character(1)}]\cr{}
the name of the journal
\item \code{issn}         [\code{character(1)}]\cr{}
the ISSN of the journal
\item \code{romeocolour}  [\code{character(1)}]\cr{}
the SHERPA/RoMEO colour of the journal
\item \code{preprint}     [\code{character(1)}]\cr{}
is the preprint (not reviewed) archivable?
\item \code{postprint}    [\code{character(1)}]\cr{}
is the postprint (reviewed but not formatted)?
\item \code{pdf}          [\code{character(1)}]\cr{}
is the publisher's version (reviewed and formatted)
\item \code{pre_embargo}  [\code{character(1)}]\cr{}
if applicable the embargo period before the author(s) can
archive the preprint
\item \code{post_embargo} [\code{character(1)}]\cr{}
if applicable the embargo period before the author(s) can
archive the postprint
\item \code{pdf_embargo}  [\code{character(1)}]\cr{}
if applicable the embargo period before the author(s) can
archive the publisher's version
}
}
\description{
Retrieve policy information from the SHERPA/RoMEO API using the ISSN of
the journal
}
\details{
There are several ways to provide your API key.
The best way to know about them is to refer to the vignette about
"Setting Up Your API key" accessible with the following command:
\code{vignette("setting_up_api_key", package = "rromeo")}.
You can also use \code{\link{rr_auth}} that will use the provided key to store it as
an environmental variable.
}
\examples{
\donttest{
rr_journal_issn(issn = "1947-6264")
rr_journal_issn(issn = c("1947-6264", "0030-1299"))
}
}
