% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tMoveRes.R
\name{tMoveRes}
\alias{tMoveRes}
\title{tMoveRes}
\usage{
tMoveRes(xy = xy, o.time = o.time, t.res = t.res, s.res = s.res)
}
\arguments{
\item{xy}{Object of class \emph{SpatialPoints} or \emph{SpatialPointsDataFrame}.}

\item{o.time}{Object of class \emph{Date}, \emph{POSIXlt} or \emph{POSIXct} with \emph{xy} observation dates.}

\item{t.res}{Temporal resolution.}

\item{s.res}{Spatial resolution.}
}
\value{
A \emph{list}.
}
\description{
Provides historical information on cloud cover.
}
\details{
{Given a vector of temporal resolutions (\emph{t.res}), the function determines
the number of unique pixels and unique pixel groups after their temporal agggation. The
function returns the corresponding pixel indices per resolution showing which
samples would be grouped (\emph{$indices}). The function returns a data frame (\emph{$stats})
and a plot (\emph{$plot}) with the statistics per temporal resolution.}
}
\examples{
\dontrun{

 require(raster)

 # read raster data
 r <- raster(system.file('extdata', 'tcb_1.tif', package="rsMove"))

 # read movement data
 moveData <- read.csv(system.file('extdata', 'konstanz_20130804.csv', package="rsMove"))
 moveData <- SpatialPointsDataFrame(moveData[,1:2], moveData, proj4string=crs(r))

 # test function for 5, 10 20 and 30 m
 a.res <- tMoveRes(xy=moveData, dpath='.')

}
}
\seealso{
\code{\link{sMoveRes}} \code{\link{specVar}}
}
